/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import net.finmath.functions.NormalDistribution;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.stochastic.RandomVariable;

public class BachelierModel {
    private BachelierModel() {
    }

    public static double bachelierOptionValue(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (forward == optionStrike) {
            return volatility * Math.sqrt(optionMaturity / Math.PI / 2.0) * payoffUnit;
        }
        double dPlus = (forward - optionStrike) / (volatility * Math.sqrt(optionMaturity));
        double valueAnalytic = ((forward - optionStrike) * NormalDistribution.cumulativeDistribution(dPlus) + volatility * Math.sqrt(optionMaturity) * NormalDistribution.density(dPlus)) * payoffUnit;
        return valueAnalytic;
    }

    public static RandomVariable bachelierOptionValue(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        if (optionMaturity < 0.0) {
            return forward.mult(0.0);
        }
        RandomVariable integratedVolatility = volatility.mult(Math.sqrt(optionMaturity));
        RandomVariable dPlus = forward.sub(optionStrike).div(integratedVolatility);
        RandomVariable valueAnalytic = dPlus.apply(NormalDistribution::cumulativeDistribution).mult(forward.sub(optionStrike)).add(dPlus.apply(NormalDistribution::density).mult(integratedVolatility)).mult(payoffUnit);
        return valueAnalytic;
    }

    public static double bachelierOptionImpliedVolatility(double forward, double optionMaturity, double optionStrike, double payoffUnit, double optionValue) {
        int maxIterations = 100;
        double maxAccuracy = 0.0;
        double volatilityLowerBound = 0.0;
        double volatilityUpperBound = Math.sqrt(17.079468445347132) * (optionValue / payoffUnit + Math.abs(forward - optionStrike)) / Math.sqrt(optionMaturity);
        GoldenSectionSearch solver = new GoldenSectionSearch(0.0, volatilityUpperBound);
        while (solver.getAccuracy() > 0.0 && !solver.isDone() && solver.getNumberOfIterations() < 100) {
            double volatility = solver.getNextPoint();
            double valueAnalytic = BachelierModel.bachelierOptionValue(forward, volatility, optionMaturity, optionStrike, payoffUnit);
            double error = valueAnalytic - optionValue;
            solver.setValue(error * error);
        }
        return solver.getBestPoint();
    }

    public static double bachelierOptionDelta(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (forward == optionStrike) {
            return 0.5;
        }
        double dPlus = (forward - optionStrike) / (volatility * Math.sqrt(optionMaturity));
        double deltaAnalytic = NormalDistribution.cumulativeDistribution(dPlus);
        return deltaAnalytic;
    }

    public static RandomVariable bachelierOptionDelta(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        if (optionMaturity < 0.0) {
            return forward.mult(0.0);
        }
        RandomVariable integratedVolatility = volatility.mult(Math.sqrt(optionMaturity));
        RandomVariable dPlus = forward.sub(optionStrike).div(integratedVolatility);
        RandomVariable deltaAnalytic = dPlus.apply(NormalDistribution::cumulativeDistribution);
        return deltaAnalytic;
    }

    public static double bachelierOptionVega(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        if (optionMaturity < 0.0) {
            return 0.0;
        }
        if (forward == optionStrike) {
            return Math.sqrt(optionMaturity / (Math.PI * 2)) * payoffUnit;
        }
        double dPlus = (forward - optionStrike) / (volatility * Math.sqrt(optionMaturity));
        double vegaAnalytic = Math.sqrt(optionMaturity) * NormalDistribution.density(dPlus) * payoffUnit;
        return vegaAnalytic;
    }

    public static RandomVariable bachelierOptionVega(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        if (optionMaturity < 0.0) {
            return forward.mult(0.0);
        }
        RandomVariable integratedVolatility = volatility.mult(Math.sqrt(optionMaturity));
        RandomVariable dPlus = forward.sub(optionStrike).div(integratedVolatility);
        RandomVariable vegaAnalytic = dPlus.apply(NormalDistribution::density).mult(payoffUnit).mult(Math.sqrt(optionMaturity));
        return vegaAnalytic;
    }

    public static double bachelierHomogeneousOptionValue(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        return BachelierModel.bachelierOptionValue(forward, volatility / payoffUnit, optionMaturity, optionStrike, payoffUnit);
    }

    public static RandomVariable bachelierHomogeneousOptionValue(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        return BachelierModel.bachelierOptionValue(forward, volatility.div(payoffUnit), optionMaturity, optionStrike, payoffUnit);
    }

    public static double bachelierHomogeneousOptionImpliedVolatility(double forward, double optionMaturity, double optionStrike, double payoffUnit, double optionValue) {
        return BachelierModel.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue) * payoffUnit;
    }

    public static double bachelierHomogeneousOptionDelta(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        return BachelierModel.bachelierOptionDelta(forward, volatility / payoffUnit, optionMaturity, optionStrike, payoffUnit);
    }

    public static RandomVariable bachelierHomogeneousOptionDelta(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        return BachelierModel.bachelierOptionDelta(forward, volatility.div(payoffUnit), optionMaturity, optionStrike, payoffUnit);
    }

    public static double bachelierHomogeneousOptionVega(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        return BachelierModel.bachelierOptionVega(forward, volatility / payoffUnit, optionMaturity, optionStrike, payoffUnit) / payoffUnit;
    }

    public static RandomVariable bachelierHomogeneousOptionVega(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        return BachelierModel.bachelierOptionVega(forward, volatility.div(payoffUnit), optionMaturity, optionStrike, payoffUnit).div(payoffUnit);
    }

    public static double bachelierInhomogeneousOptionValue(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        double scaling = payoffUnit != 1.0 ? Math.sqrt((payoffUnit * payoffUnit - 1.0) / (2.0 * Math.log(payoffUnit))) : 1.0;
        double volatilityEffective = volatility * scaling;
        return BachelierModel.bachelierHomogeneousOptionValue(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
    }

    public static RandomVariable bachelierInhomogeneousOptionValue(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        RandomVariable volatilityEffective = volatility.mult(payoffUnit.squared().sub(1.0).div(payoffUnit.log().mult(2.0)).sqrt());
        return BachelierModel.bachelierHomogeneousOptionValue(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
    }

    public static double bachelierInhomogeneousOptionImpliedVolatility(double forward, double optionMaturity, double optionStrike, double payoffUnit, double optionValue) {
        double volatilityEffective = BachelierModel.bachelierHomogeneousOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, optionValue);
        double scaling = payoffUnit != 1.0 ? Math.sqrt((payoffUnit * payoffUnit - 1.0) / (2.0 * Math.log(payoffUnit))) : 1.0;
        double volatility = volatilityEffective / scaling;
        return volatility;
    }

    public static double bachelierInhomogeneousOptionDelta(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        double scaling = payoffUnit != 1.0 ? Math.sqrt((payoffUnit * payoffUnit - 1.0) / (2.0 * Math.log(payoffUnit))) : 1.0;
        double volatilityEffective = volatility * scaling;
        return BachelierModel.bachelierHomogeneousOptionDelta(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
    }

    public static RandomVariable bachelierInhomogeneousOptionDelta(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        RandomVariable volatilityEffective = volatility.mult(payoffUnit.squared().sub(1.0).div(payoffUnit.log().mult(2.0)).sqrt());
        return BachelierModel.bachelierHomogeneousOptionDelta(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
    }

    public static double bachelierInhomogeneousOptionVega(double forward, double volatility, double optionMaturity, double optionStrike, double payoffUnit) {
        double scaling = payoffUnit != 1.0 ? Math.sqrt((payoffUnit * payoffUnit - 1.0) / (2.0 * Math.log(payoffUnit))) : 1.0;
        double volatilityEffective = volatility * scaling;
        double vegaHomogenouse = BachelierModel.bachelierHomogeneousOptionVega(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
        return vegaHomogenouse * scaling;
    }

    public static RandomVariable bachelierInhomogeneousOptionVega(RandomVariable forward, RandomVariable volatility, double optionMaturity, double optionStrike, RandomVariable payoffUnit) {
        RandomVariable volatilityEffective = volatility.mult(payoffUnit.squared().sub(1.0).div(payoffUnit.log().mult(2.0)).sqrt());
        RandomVariable vegaHomogenouse = BachelierModel.bachelierHomogeneousOptionVega(forward, volatilityEffective, optionMaturity, optionStrike, payoffUnit);
        return vegaHomogenouse.mult(volatilityEffective).div(volatility);
    }
}

