/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import net.finmath.integration.AbstractRealIntegral;
import net.finmath.randomnumbers.MersenneTwister;
import org.apache.commons.lang3.Validate;

public class MonteCarloIntegrator
extends AbstractRealIntegral {
    private final int numberOfEvaluationPoints;
    private final int seed;

    public MonteCarloIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints, int seed, boolean useParallelEvaluation) {
        super(lowerBound, upperBound);
        Validate.exclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)numberOfEvaluationPoints, (String)"Parameter numberOfEvaluationPoints required to be > 0.");
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
        this.seed = seed;
    }

    public MonteCarloIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints, boolean useParallelEvaluation) {
        this(lowerBound, upperBound, numberOfEvaluationPoints, 3141, useParallelEvaluation);
    }

    public MonteCarloIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this(lowerBound, upperBound, numberOfEvaluationPoints, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator integrand) {
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double range = upperBound - lowerBound;
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        DoubleStream randomNumberSequence = DoubleStream.generate(mersenneTwister).limit(this.numberOfEvaluationPoints);
        return randomNumberSequence.map(x -> lowerBound + x * range).map(integrand).sum() * range / (double)this.numberOfEvaluationPoints;
    }

    public int getNumberOfEvaluationPoints() {
        return this.numberOfEvaluationPoints;
    }

    public int getSeed() {
        return this.seed;
    }
}

