/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata.calibration.ParameterObject;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class AnalyticModelFromCurvesAndVols
implements AnalyticModel,
Serializable,
Cloneable {
    private static final long serialVersionUID = 6906386712907555046L;
    private final LocalDate referenceDate;
    private final Map<String, Curve> curvesMap = new HashMap<String, Curve>();
    private final Map<String, VolatilitySurface> volatilitySurfaceMap = new HashMap<String, VolatilitySurface>();

    public AnalyticModelFromCurvesAndVols() {
        this.referenceDate = null;
    }

    public AnalyticModelFromCurvesAndVols(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public AnalyticModelFromCurvesAndVols(Curve[] curves) {
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
        this.referenceDate = null;
    }

    public AnalyticModelFromCurvesAndVols(Collection<Curve> curves) {
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
        this.referenceDate = null;
    }

    public AnalyticModelFromCurvesAndVols(LocalDate referenceDate, Curve[] curves) {
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
            LocalDate curveDate = curve.getReferenceDate();
            if (referenceDate == null || curveDate == null || referenceDate.equals(curveDate)) continue;
            throw new IllegalArgumentException("Reference date of curve " + curve.getName() + " does not match the reference date of the model.");
        }
        this.referenceDate = referenceDate;
    }

    public AnalyticModelFromCurvesAndVols(LocalDate referenceDate, Collection<Curve> curves) {
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
            LocalDate curveDate = curve.getReferenceDate();
            if (referenceDate == null || curveDate == null || referenceDate.equals(curveDate)) continue;
            throw new IllegalArgumentException("Reference date of curve " + curve.getName() + " does not match the reference date of the model.");
        }
        this.referenceDate = referenceDate;
    }

    public AnalyticModelFromCurvesAndVols(LocalDate referenceDate, Map<String, Curve> curvesMap, Map<String, VolatilitySurface> volatilitySurfaceMap) {
        this(referenceDate);
        this.curvesMap.putAll(curvesMap);
        this.volatilitySurfaceMap.putAll(volatilitySurfaceMap);
    }

    @Override
    public Curve getCurve(String name) {
        return this.curvesMap.get(name);
    }

    @Override
    public Map<String, Curve> getCurves() {
        return Collections.unmodifiableMap(this.curvesMap);
    }

    @Override
    public AnalyticModel addCurve(String name, Curve curve) {
        LocalDate curveDate = curve.getReferenceDate();
        if (this.referenceDate != null && curveDate != null && !this.referenceDate.equals(curveDate)) {
            throw new IllegalArgumentException("Reference date of curve does not match reference date of model.");
        }
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.put(name, curve);
        return newModel;
    }

    public AnalyticModel addCurve(Curve curve) {
        LocalDate curveDate = curve.getReferenceDate();
        if (this.referenceDate != null && curveDate != null && !this.referenceDate.equals(curveDate)) {
            throw new IllegalArgumentException("Reference date of curve does not match reference date of model.");
        }
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.put(curve.getName(), curve);
        return newModel;
    }

    @Override
    public AnalyticModel addCurves(Curve ... curves) {
        HashMap<String, Curve> curvesMap = new HashMap<String, Curve>();
        for (Curve curve : curves) {
            curvesMap.put(curve.getName(), curve);
            LocalDate curveDate = curve.getReferenceDate();
            if (this.referenceDate == null || curveDate == null || this.referenceDate.equals(curveDate)) continue;
            throw new IllegalArgumentException("Reference date of curve " + curve.getName() + " does not match the reference date of the model.");
        }
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.putAll(curvesMap);
        return newModel;
    }

    @Override
    public AnalyticModel addCurves(Set<Curve> curves) {
        HashMap<String, Curve> curvesMap = new HashMap<String, Curve>();
        for (Curve curve : curves) {
            curvesMap.put(curve.getName(), curve);
            LocalDate curveDate = curve.getReferenceDate();
            if (this.referenceDate == null || curveDate == null || this.referenceDate.equals(curveDate)) continue;
            throw new IllegalArgumentException("Reference date of curve " + curve.getName() + " does not match the reference date of the model.");
        }
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.putAll(curvesMap);
        return newModel;
    }

    @Override
    public DiscountCurve getDiscountCurve(String discountCurveName) {
        DiscountCurve discountCurve = null;
        Curve curve = this.getCurve(discountCurveName);
        if (DiscountCurve.class.isInstance(curve)) {
            discountCurve = (DiscountCurve)curve;
        }
        return discountCurve;
    }

    @Override
    public ForwardCurve getForwardCurve(String forwardCurveName) {
        ForwardCurve forwardCurve = null;
        Curve curve = this.getCurve(forwardCurveName);
        if (ForwardCurve.class.isInstance(curve)) {
            forwardCurve = (ForwardCurve)curve;
        }
        return forwardCurve;
    }

    @Override
    public VolatilitySurface getVolatilitySurface(String name) {
        return this.volatilitySurfaceMap.get(name);
    }

    @Override
    public Map<String, VolatilitySurface> getVolatilitySurfaces() {
        return Collections.unmodifiableMap(this.volatilitySurfaceMap);
    }

    public AnalyticModel addVolatilitySurface(VolatilitySurface volatilitySurface) {
        LocalDate surfaceDate = volatilitySurface.getReferenceDate();
        if (this.referenceDate != null && surfaceDate != null && !this.referenceDate.equals(surfaceDate)) {
            throw new IllegalArgumentException("Reference date of surface does not match reference date of model.");
        }
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        return newModel;
    }

    @Override
    public AnalyticModel addVolatilitySurfaces(VolatilitySurface ... volatilitySurfaces) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (VolatilitySurface volatilitySurface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
            LocalDate surfaceDate = volatilitySurface.getReferenceDate();
            if (this.referenceDate == null || surfaceDate == null || this.referenceDate.equals(surfaceDate)) continue;
            throw new IllegalArgumentException("Reference date of surface " + volatilitySurface.getName() + " does not match the reference date of the model.");
        }
        return newModel;
    }

    @Override
    public AnalyticModel addVolatilitySurfaces(Set<VolatilitySurface> volatilitySurfaces) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (VolatilitySurface volatilitySurface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
            LocalDate surfaceDate = volatilitySurface.getReferenceDate();
            if (this.referenceDate == null || surfaceDate == null || this.referenceDate.equals(surfaceDate)) continue;
            throw new IllegalArgumentException("Reference date of surface " + volatilitySurface.getName() + " does not match the reference date of the model.");
        }
        return newModel;
    }

    private void setCurve(Curve curve) {
        this.curvesMap.put(curve.getName(), curve);
    }

    private void setVolatilitySurface(VolatilitySurface volatilitySurface) {
        this.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
    }

    private void set(Object marketDataObject) {
        if (marketDataObject instanceof Curve) {
            this.setCurve((Curve)marketDataObject);
        } else if (marketDataObject instanceof VolatilitySurface) {
            this.setVolatilitySurface((VolatilitySurface)marketDataObject);
        } else {
            throw new IllegalArgumentException("Provided object is not of supported type.");
        }
    }

    @Override
    public AnalyticModelFromCurvesAndVols clone() {
        AnalyticModelFromCurvesAndVols newModel = new AnalyticModelFromCurvesAndVols(this.referenceDate);
        newModel.curvesMap.putAll(this.curvesMap);
        newModel.volatilitySurfaceMap.putAll(this.volatilitySurfaceMap);
        return newModel;
    }

    @Override
    public AnalyticModel getCloneForParameter(Map<ParameterObject, double[]> curveParameterPairs) throws CloneNotSupportedException {
        AnalyticModelFromCurvesAndVols modelClone = this.clone();
        if (curveParameterPairs != null) {
            for (Map.Entry<ParameterObject, double[]> curveParameterPair : curveParameterPairs.entrySet()) {
                ParameterObject newCurve = curveParameterPair.getKey().getCloneForParameter(curveParameterPair.getValue());
                modelClone.set(newCurve);
            }
        }
        return modelClone;
    }

    public String toString() {
        return "AnalyticModelFromCurvesAndVols: referenceDate=" + this.referenceDate + ", curves=" + this.curvesMap.keySet() + ", volatilitySurfaces=" + this.volatilitySurfaceMap.keySet();
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }
}

