/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.curves.Curve;

public abstract class AbstractCurve
implements Curve,
Serializable,
Cloneable {
    private static final long serialVersionUID = 584342257323693502L;
    private final LocalDate referenceDate;
    private final String name;

    public AbstractCurve(String name, LocalDate referenceDate) {
        this.name = name;
        this.referenceDate = referenceDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    public double[] getValues(double[] times) {
        double[] values = new double[times.length];
        for (int i = 0; i < times.length; ++i) {
            values[i] = this.getValue(null, times[i]);
        }
        return values;
    }

    @Override
    public AbstractCurve clone() throws CloneNotSupportedException {
        return (AbstractCurve)super.clone();
    }

    @Override
    public Curve getCloneForParameter(double[] value) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "AbstractCurve [name=" + this.name + ", referenceDate=" + this.referenceDate + "]";
    }
}

