/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractForwardCurve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.daycount.DayCountConvention;

public class ForwardCurveFromDiscountCurve
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private final String referenceDiscountCurveForForwardsName;
    private final DayCountConvention daycountConvention;
    private final double daycountScaling;
    private final double periodOffset;

    public ForwardCurveFromDiscountCurve(String name, String referenceDiscountCurveName, String discountCurveName, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentOffsetBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentOffsetDateRollConvention, DayCountConvention daycountConvention, double periodOffset) {
        super(name, referenceDate, paymentOffsetCode, paymentOffsetBusinessdayCalendar, paymentOffsetDateRollConvention, discountCurveName);
        this.referenceDiscountCurveForForwardsName = referenceDiscountCurveName;
        this.daycountConvention = daycountConvention;
        this.daycountScaling = 1.0;
        this.periodOffset = periodOffset;
    }

    public ForwardCurveFromDiscountCurve(String name, String referenceDiscountCurveName, String discountCurveName, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentOffsetBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentOffsetDateRollConvention, double daycountScaling, double periodOffset) {
        super(name, referenceDate, paymentOffsetCode, paymentOffsetBusinessdayCalendar, paymentOffsetDateRollConvention, discountCurveName);
        this.referenceDiscountCurveForForwardsName = referenceDiscountCurveName;
        this.daycountConvention = null;
        this.daycountScaling = daycountScaling;
        this.periodOffset = periodOffset;
    }

    public ForwardCurveFromDiscountCurve(String name, String referenceDiscountCurveName, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentOffsetBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentOffsetDateRollConvention, double daycountScaling, double periodOffset) {
        this(name, referenceDiscountCurveName, referenceDiscountCurveName, referenceDate, paymentOffsetCode, paymentOffsetBusinessdayCalendar, paymentOffsetDateRollConvention, daycountScaling, periodOffset);
    }

    public ForwardCurveFromDiscountCurve(String name, String referenceDiscountCurveName, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentOffsetBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentOffsetDateRollConvention) {
        this(name, referenceDiscountCurveName, referenceDate, paymentOffsetCode, paymentOffsetBusinessdayCalendar, paymentOffsetDateRollConvention, 1.0, 0.0);
    }

    public ForwardCurveFromDiscountCurve(String name, String referenceDiscountCurveName, LocalDate referenceDate, String paymentOffsetCode) {
        this(name, referenceDiscountCurveName, referenceDate, paymentOffsetCode, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendar.DateRollConvention.FOLLOWING);
    }

    public ForwardCurveFromDiscountCurve(String referenceDiscountCurveName, LocalDate referenceDate, String paymentOffsetCode) {
        this("ForwardCurveFromDiscountCurve(" + referenceDiscountCurveName + "," + paymentOffsetCode + ")", referenceDiscountCurveName, referenceDate, paymentOffsetCode);
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime) {
        double paymentOffset = this.getPaymentOffset(fixingTime + this.periodOffset);
        return this.getForward(model, fixingTime, paymentOffset);
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime, double paymentOffset) {
        if (model == null) {
            throw new IllegalArgumentException(this.getName() + ": model==null");
        }
        DiscountCurve referenceDiscountCurveForForwards = model.getDiscountCurve(this.referenceDiscountCurveForForwardsName);
        if (referenceDiscountCurveForForwards == null) {
            throw new IllegalArgumentException(this.getName() + ": referenceDiscountCurveForForwards " + this.referenceDiscountCurveForForwardsName + " not found in the model:\n" + model.toString());
        }
        if (Double.isNaN(paymentOffset) || paymentOffset <= 0.0) {
            throw new IllegalArgumentException(this.getName() + ": Requesting forward with paymentOffset " + paymentOffset + " not allowed.");
        }
        double daycount = (this.daycountConvention != null ? this.daycountConvention.getDaycountFraction(FloatingpointDate.getDateFromFloatingPointDate(this.getReferenceDate(), fixingTime), FloatingpointDate.getDateFromFloatingPointDate(this.getReferenceDate(), fixingTime + paymentOffset)) : paymentOffset) * this.daycountScaling;
        return (referenceDiscountCurveForForwards.getDiscountFactor(model, fixingTime + this.periodOffset) / referenceDiscountCurveForForwards.getDiscountFactor(model, fixingTime + paymentOffset + this.periodOffset) - 1.0) / daycount;
    }

    @Override
    public double getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        return this.getForward(model, time);
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public String toString() {
        return "ForwardCurveFromDiscountCurve [" + super.toString() + ", referenceDiscountCurveForForwardsName=" + this.referenceDiscountCurveForForwardsName + ", daycountScaling=" + this.daycountScaling + ", periodOffset=" + this.periodOffset + "]";
    }
}

