/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.calibration.ParameterObject;
import net.finmath.marketdata.calibration.ParameterTransformation;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.optimizer.OptimizerFactory;
import net.finmath.optimizer.SolverException;
import net.finmath.time.daycount.DayCountConvention;

public abstract class AbstractVolatilitySurfaceParametric
extends AbstractVolatilitySurface
implements ParameterObject {
    private static final Logger logger = Logger.getLogger("net.finmath");

    public AbstractVolatilitySurfaceParametric(String name, LocalDate referenceDate, ForwardCurve forwardCurve, DiscountCurve discountCurve, VolatilitySurface.QuotingConvention quotingConvention, DayCountConvention daycountConvention) {
        super(name, referenceDate, forwardCurve, discountCurve, quotingConvention, daycountConvention);
    }

    public AbstractVolatilitySurfaceParametric(String name, LocalDate referenceDate) {
        super(name, referenceDate);
    }

    @Override
    public abstract AbstractVolatilitySurfaceParametric getCloneForParameter(double[] var1) throws CloneNotSupportedException;

    public AbstractVolatilitySurfaceParametric getCloneCalibrated(AnalyticModel calibrationModel, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, Map<String, Object> calibrationParameters) throws CalculationException, SolverException {
        return this.getCloneCalibrated(calibrationModel, calibrationProducts, calibrationTargetValues, calibrationParameters, null);
    }

    public AbstractVolatilitySurfaceParametric getCloneCalibrated(AnalyticModel calibrationModel, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, Map<String, Object> calibrationParameters, ParameterTransformation parameterTransformation) throws CalculationException, SolverException {
        return this.getCloneCalibrated(calibrationModel, calibrationProducts, calibrationTargetValues, calibrationParameters, parameterTransformation, null);
    }

    public AbstractVolatilitySurfaceParametric getCloneCalibrated(AnalyticModel calibrationModel, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, Map<String, Object> calibrationParameters, ParameterTransformation parameterTransformation, OptimizerFactory optimizerFactory) throws SolverException {
        if (calibrationParameters == null) {
            calibrationParameters = new HashMap<String, Object>();
        }
        Integer maxIterationsParameter = (Integer)calibrationParameters.get("maxIterations");
        Double accuracyParameter = (Double)calibrationParameters.get("accuracy");
        Double evaluationTimeParameter = (Double)calibrationParameters.get("evaluationTime");
        int maxIterations = maxIterationsParameter != null ? maxIterationsParameter : 600;
        double accuracy = accuracyParameter != null ? accuracyParameter : 1.0E-8;
        double evaluationTime = evaluationTimeParameter != null ? evaluationTimeParameter : 0.0;
        AnalyticModel model = calibrationModel.addVolatilitySurfaces(this);
        Solver solver = new Solver(model, calibrationProducts, calibrationTargetValues, parameterTransformation, evaluationTime, optimizerFactory);
        HashSet<ParameterObject> objectsToCalibrate = new HashSet<ParameterObject>();
        objectsToCalibrate.add(this);
        AnalyticModel modelCalibrated = solver.getCalibratedModel(objectsToCalibrate);
        if (logger.isLoggable(Level.FINE)) {
            double lastAccuracy = solver.getAccuracy();
            int lastIterations = solver.getIterations();
            logger.fine("The solver achieved an accuracy of " + lastAccuracy + " in " + lastIterations + ".");
        }
        return (AbstractVolatilitySurfaceParametric)modelCalibrated.getVolatilitySurface(this.getName());
    }
}

