/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import java.util.HashMap;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.volatilities.OptionSmileData;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class OptionSurfaceData {
    private final String underlying;
    private final LocalDate referenceDate;
    private final DiscountCurve discountCurve;
    private final DiscountCurve equityForwardCurve;
    private final VolatilitySurface.QuotingConvention convention;
    private final HashMap<Double, OptionSmileData> surface;
    private final double[] maturities;

    public OptionSurfaceData(String underlying, LocalDate referenceDate, double[] strikes, double[] maturities, double[][] values, VolatilitySurface.QuotingConvention convention, DiscountCurve discountCurve, DiscountCurve equityForwardCurve) {
        if (strikes.length != values.length || maturities.length != values[0].length) {
            throw new IllegalArgumentException("Inconsistent number of strikes, maturities or values");
        }
        this.surface = new HashMap();
        for (int j = 0; j < maturities.length; ++j) {
            double[] valuesOfInterest = new double[strikes.length];
            for (int i = 0; i < strikes.length; ++i) {
                valuesOfInterest[i] = values[i][j];
            }
            OptionSmileData jthSmile = new OptionSmileData(underlying, referenceDate, strikes, maturities[j], valuesOfInterest, convention);
            this.surface.put(maturities[j], jthSmile);
        }
        this.underlying = underlying;
        this.referenceDate = referenceDate;
        this.discountCurve = discountCurve;
        this.equityForwardCurve = equityForwardCurve;
        this.convention = convention;
        this.maturities = maturities;
    }

    public OptionSurfaceData(OptionSmileData[] smiles, DiscountCurve discountCurve, DiscountCurve equityForwardCurve) {
        OptionSmileData firstSmile = smiles[0];
        String myUnderlying = firstSmile.getUnderlying();
        LocalDate myReferenceDate = firstSmile.getReferenceDate();
        VolatilitySurface.QuotingConvention myConvention = firstSmile.getSmile().get(firstSmile.getStrikes()[0]).getConvention();
        HashMap<Double, OptionSmileData> mySurface = new HashMap<Double, OptionSmileData>();
        double[] mats = new double[smiles.length];
        for (int t = 0; t < smiles.length; ++t) {
            double maturity;
            mats[t] = maturity = smiles[t].getMaturity();
            if (!smiles[t].getReferenceDate().equals(myReferenceDate)) {
                throw new IllegalArgumentException("All reference dates must be equal");
            }
            if (!smiles[t].getUnderlying().equals(myUnderlying)) {
                throw new IllegalArgumentException("Option must be written on the same underlying");
            }
            VolatilitySurface.QuotingConvention testConvention = smiles[t].getSmile().get(smiles[t].getStrikes()[0]).getConvention();
            if (!testConvention.equals((Object)myConvention)) {
                throw new IllegalArgumentException("Convention must be the same for all points in the surface");
            }
            mySurface.put(maturity, smiles[t]);
        }
        this.underlying = myUnderlying;
        this.referenceDate = myReferenceDate;
        this.discountCurve = discountCurve;
        this.equityForwardCurve = equityForwardCurve;
        this.surface = mySurface;
        this.convention = myConvention;
        this.maturities = mats;
    }

    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    public DiscountCurve getEquityForwardCurve() {
        return this.equityForwardCurve;
    }

    public String getName() {
        return this.underlying;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public VolatilitySurface.QuotingConvention getQuotingConvention() {
        return this.convention;
    }

    public HashMap<Double, OptionSmileData> getSurface() {
        return this.surface;
    }

    public double[] getMaturities() {
        return this.maturities;
    }

    public double getValue(double maturity, double strike) {
        return this.getValue(maturity, strike, this.convention);
    }

    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        if (quotingConvention.equals((Object)this.convention)) {
            OptionSmileData relevantSmile = this.surface.get(maturity);
            return relevantSmile.getSmile().get(strike).getValue();
        }
        if (quotingConvention == VolatilitySurface.QuotingConvention.PRICE && this.convention == VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) {
            double forwardPrice = this.equityForwardCurve.getValue(maturity);
            double discountBond = this.discountCurve.getValue(maturity);
            OptionSmileData relevantSmile = this.surface.get(maturity);
            double volatility = relevantSmile.getSmile().get(strike).getValue();
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(forwardPrice, volatility, maturity, strike, discountBond);
        }
        if (quotingConvention == VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL && this.convention == VolatilitySurface.QuotingConvention.PRICE) {
            double forwardPrice = this.equityForwardCurve.getValue(maturity);
            double discountBond = this.discountCurve.getValue(maturity);
            OptionSmileData relevantSmile = this.surface.get(maturity);
            double price = relevantSmile.getSmile().get(strike).getValue();
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(forwardPrice, maturity, strike, discountBond, price);
        }
        return 0.0;
    }

    public OptionSmileData getSmile(double maturity) {
        return this.surface.get(maturity);
    }
}

