/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet;

import java.time.LocalDate;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.model.volatility.caplet.CapShiftedVol;
import net.finmath.marketdata.model.volatility.caplet.CapVolMarketData;
import net.finmath.marketdata.model.volatility.caplet.CapletVolatilitySurface;
import net.finmath.marketdata.model.volatility.caplet.tenorconversion.CorrelationProvider;
import net.finmath.marketdata.model.volatility.caplet.tenorconversion.TenorConverter;
import net.finmath.rootfinder.BisectionSearch;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;

public class CapletVolBootstrapping {
    private final CapVolMarketData capVolMarketData;
    private final DiscountCurve discountCurve;
    private final ForwardCurve forwardCurve;
    private double[][] capletVolMatrix;
    private double[] capletFixingTimeVectorInYears;
    private final CorrelationProvider correlationProvider;
    private transient AnalyticModel analyticModel;

    public CapletVolBootstrapping(CorrelationProvider correlationProvider, CapVolMarketData capVolMarketData, AnalyticModel parsedModel) {
        this.capVolMarketData = capVolMarketData;
        this.correlationProvider = correlationProvider;
        this.analyticModel = parsedModel;
        String currency = null;
        switch (capVolMarketData.getCapTenorStructure()) {
            case EUR: {
                currency = "EUR";
                break;
            }
            case USD: {
                currency = "USD";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown currency " + (Object)((Object)capVolMarketData.getCapTenorStructure()) + ".");
            }
        }
        this.forwardCurve = parsedModel.getForwardCurve("Forward_" + currency + "_" + capVolMarketData.getIndex());
        this.discountCurve = parsedModel.getDiscountCurve(currency + "_" + capVolMarketData.getDiscountIndex());
    }

    public CapletVolBootstrapping(CapVolMarketData capVolMarketData, AnalyticModel parsedModel) {
        this(null, capVolMarketData, parsedModel);
    }

    public double[][] getCapletVolMatrix() throws CalculationException {
        this.capletVolMatrix = new double[this.capVolMarketData.getMaxExpiryInMonths() / this.capVolMarketData.getUnderlyingTenorInMonths() - 1][this.capVolMarketData.getNumberOfStrikes()];
        this.capletFixingTimeVectorInYears = new double[this.capVolMarketData.getMaxExpiryInMonths() / this.capVolMarketData.getUnderlyingTenorInMonths() - 1];
        for (int i = 0; i < this.capletFixingTimeVectorInYears.length; ++i) {
            this.capletFixingTimeVectorInYears[i] = (double)((i + 1) * this.capVolMarketData.getUnderlyingTenorInMonths()) / 12.0;
        }
        ScheduleGenerator.Frequency frequency = null;
        switch (this.capVolMarketData.getUnderlyingTenorInMonths()) {
            case 1: {
                frequency = ScheduleGenerator.Frequency.MONTHLY;
                break;
            }
            case 3: {
                frequency = ScheduleGenerator.Frequency.QUARTERLY;
                break;
            }
            case 6: {
                frequency = ScheduleGenerator.Frequency.SEMIANNUAL;
                break;
            }
            case 12: {
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tenor " + this.capVolMarketData.getUnderlyingTenorInMonths() + ".");
            }
        }
        if (this.capVolMarketData.getUnderlyingTenorInMonths() != this.capVolMarketData.getUnderlyingTenorInMonthsBeforeChange()) {
            int i;
            int numberOfExpiriesBeforeChange = 0;
            while (this.capVolMarketData.getExpiryInMonths(numberOfExpiriesBeforeChange) <= this.capVolMarketData.getTenorChangeTimeInMonths()) {
                ++numberOfExpiriesBeforeChange;
            }
            int[] expiryVectorInMonthsBeforeChange = new int[numberOfExpiriesBeforeChange];
            for (int i2 = 0; i2 < numberOfExpiriesBeforeChange; ++i2) {
                expiryVectorInMonthsBeforeChange[i2] = this.capVolMarketData.getExpiryInMonths(i2);
            }
            double[][] capVolMatrixBeforeChange = new double[numberOfExpiriesBeforeChange][this.capVolMarketData.getNumberOfStrikes()];
            for (int j = 0; j < this.capVolMarketData.getNumberOfStrikes(); ++j) {
                for (i = 0; i < numberOfExpiriesBeforeChange; ++i) {
                    capVolMatrixBeforeChange[i][j] = this.capVolMarketData.getVolMatrix()[i][j];
                }
            }
            double[] capletFixingTimeVectorInYearsBeforeChange = new double[this.capVolMarketData.getMaxExpiryInMonths() / this.capVolMarketData.getUnderlyingTenorInMonths() - 1];
            for (i = 0; i < capletFixingTimeVectorInYearsBeforeChange.length; ++i) {
                capletFixingTimeVectorInYearsBeforeChange[i] = (double)((i + 1) * this.capVolMarketData.getUnderlyingTenorInMonthsBeforeChange()) / 12.0;
            }
            CapVolMarketData capVolMarketDataBeforeChange = new CapVolMarketData(this.capVolMarketData.getIndexBeforeChange(), this.capVolMarketData.getDiscountIndex(), this.capVolMarketData.getCapTenorStructure(), expiryVectorInMonthsBeforeChange, this.capVolMarketData.getStrikeVector(), capVolMatrixBeforeChange, this.capVolMarketData.getShift(), this.capVolMarketData.getUnderlyingTenorInMonthsBeforeChange());
            CapletVolBootstrapping capletVolBootstrapperBeforeChange = new CapletVolBootstrapping(capVolMarketDataBeforeChange, this.analyticModel);
            TenorConverter tenorConverterBeforeChange = new TenorConverter(this.correlationProvider, capVolMarketDataBeforeChange.getUnderlyingTenorInMonthsBeforeChange(), this.capVolMarketData.getUnderlyingTenorInMonths(), capletFixingTimeVectorInYearsBeforeChange, capVolMarketDataBeforeChange.getStrikeVector(), capletVolBootstrapperBeforeChange.getCapletVolMatrix(), capVolMarketDataBeforeChange.getCapTenorStructure(), this.analyticModel, this.capVolMarketData.getDiscountIndex(), capVolMarketDataBeforeChange.getIndex(), this.capVolMarketData.getIndex());
            double[][] capVolMatrixBeforeChangeNewTenor = capletVolBootstrapperBeforeChange.calculateCapVolsFromCapletVols(tenorConverterBeforeChange.convertTenor());
            for (int j = 0; j < this.capVolMarketData.getNumberOfStrikes(); ++j) {
                for (int i3 = 0; i3 < numberOfExpiriesBeforeChange; ++i3) {
                    this.capVolMarketData.setCapVolMatrixEntry(i3, j, capVolMatrixBeforeChangeNewTenor[i3][j]);
                }
            }
        }
        for (int j = 0; j < this.capVolMarketData.getNumberOfStrikes(); ++j) {
            int lastExpiryInMonths = 0;
            int currentExpiryInMonths = this.capVolMarketData.getExpiryInMonths(0);
            int lastCaplet = 0;
            boolean isFirstCap = true;
            for (int i = 0; i < this.capVolMarketData.getMaxExpiryInMonths() / this.capVolMarketData.getUnderlyingTenorInMonths(); ++i) {
                if (currentExpiryInMonths != (i + 1) * this.capVolMarketData.getUnderlyingTenorInMonths()) continue;
                if (isFirstCap) {
                    for (int k = 0; k < i; ++k) {
                        this.capletVolMatrix[k][j] = this.capVolMarketData.getCapVolData(0, j);
                        if (j + 1 >= this.capVolMarketData.getNumberOfStrikes()) continue;
                        this.capletVolMatrix[k][j + 1] = this.capletVolMatrix[k][j];
                    }
                    isFirstCap = false;
                } else {
                    int currentExpiryRow = this.capVolMarketData.getRowIndex(currentExpiryInMonths);
                    BusinessdayCalendarExcludingTARGETHolidays businessdayCalendar = new BusinessdayCalendarExcludingTARGETHolidays(new BusinessdayCalendarExcludingWeekends());
                    LocalDate localDate = this.discountCurve.getReferenceDate();
                    LocalDate startDate = businessdayCalendar.getRolledDate(localDate, 2);
                    CapletVolatilitySurface capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, this.capVolMarketData.getCapVolData(currentExpiryRow, j), this.capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                    Schedule schedule = ScheduleGenerator.createScheduleFromConventions(localDate, startDate, localDate.plusMonths(currentExpiryInMonths), frequency, ScheduleGenerator.DaycountConvention.ACT_365, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING, (BusinessdayCalendar)businessdayCalendar, -2, 0);
                    CapShiftedVol cap = new CapShiftedVol(schedule, this.forwardCurve.getName(), this.capVolMarketData.getStrike(j), false, this.discountCurve.getName(), capletVolatilities.getName(), this.capVolMarketData.getShift());
                    double capPrice = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                    double sumCapletPrices = Double.MAX_VALUE;
                    double leftPoint = this.capVolMarketData.getCapVolData(currentExpiryRow, j) * 2.0;
                    while (capPrice - sumCapletPrices <= 0.0) {
                        leftPoint /= 1.5;
                        for (int l = i; l > lastCaplet; --l) {
                            this.capletVolMatrix[l - 1][j] = leftPoint;
                            if (j + 1 >= this.capVolMarketData.getNumberOfStrikes()) continue;
                            this.capletVolMatrix[l - 1][j + 1] = this.capletVolMatrix[l - 1][j];
                        }
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, this.capletVolMatrix, this.capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        sumCapletPrices = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        if (capPrice - sumCapletPrices != 0.0) continue;
                    }
                    double leftValue = capPrice - sumCapletPrices;
                    double rightPoint = leftPoint;
                    while (capPrice - sumCapletPrices >= 0.0) {
                        rightPoint += 0.1;
                        for (int l = i; l > lastCaplet; --l) {
                            this.capletVolMatrix[l - 1][j] = rightPoint;
                            if (j + 1 >= this.capVolMarketData.getNumberOfStrikes()) continue;
                            this.capletVolMatrix[l - 1][j + 1] = this.capletVolMatrix[l - 1][j];
                        }
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, this.capletVolMatrix, this.capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        sumCapletPrices = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        if (capPrice - sumCapletPrices != 0.0) continue;
                    }
                    double rightValue = capPrice - sumCapletPrices;
                    BisectionSearch bisectionSearch = new BisectionSearch(leftPoint, rightPoint);
                    bisectionSearch.setValue(leftValue);
                    bisectionSearch.setValue(rightValue);
                    while (!bisectionSearch.isDone()) {
                        for (int l = i; l > lastCaplet; --l) {
                            this.capletVolMatrix[l - 1][j] = bisectionSearch.getNextPoint();
                            if (j + 1 >= this.capVolMarketData.getNumberOfStrikes()) continue;
                            this.capletVolMatrix[l - 1][j + 1] = this.capletVolMatrix[l - 1][j];
                        }
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, this.capletVolMatrix, this.capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        sumCapletPrices = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        bisectionSearch.setValue(capPrice - sumCapletPrices);
                    }
                    double volaBestPoint = bisectionSearch.getBestPoint();
                    int m = i;
                    while (i - m < (currentExpiryInMonths - lastExpiryInMonths) / this.capVolMarketData.getUnderlyingTenorInMonths()) {
                        this.capletVolMatrix[m - 1][j] = volaBestPoint;
                        --m;
                    }
                }
                lastExpiryInMonths = currentExpiryInMonths;
                lastCaplet = i;
                if (this.capVolMarketData.getRowIndex(currentExpiryInMonths) + 1 >= this.capVolMarketData.getNumberOfExpiryDates()) continue;
                currentExpiryInMonths = this.capVolMarketData.getExpiryInMonths(this.capVolMarketData.getRowIndex(currentExpiryInMonths) + 1);
            }
        }
        return this.capletVolMatrix;
    }

    public double[][] calculateCapVolsFromCapletVols(double[][] inputCapletVolMatrix) {
        double[][] capVolMatrix = new double[this.capVolMarketData.getNumberOfExpiryDates()][this.capVolMarketData.getNumberOfStrikes()];
        double[] capletFixingTimeVectorInYears = new double[this.capVolMarketData.getMaxExpiryInMonths() / this.capVolMarketData.getUnderlyingTenorInMonths() - 1];
        for (int i = 0; i < capletFixingTimeVectorInYears.length; ++i) {
            capletFixingTimeVectorInYears[i] = (double)((i + 1) * this.capVolMarketData.getUnderlyingTenorInMonths()) / 12.0;
        }
        ScheduleGenerator.Frequency frequency = null;
        switch (this.capVolMarketData.getUnderlyingTenorInMonths()) {
            case 1: {
                frequency = ScheduleGenerator.Frequency.MONTHLY;
                break;
            }
            case 3: {
                frequency = ScheduleGenerator.Frequency.QUARTERLY;
                break;
            }
            case 6: {
                frequency = ScheduleGenerator.Frequency.SEMIANNUAL;
                break;
            }
            case 12: {
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tenor " + this.capVolMarketData.getUnderlyingTenorInMonths() + ".");
            }
        }
        for (int j = 0; j < this.capVolMarketData.getNumberOfStrikes(); ++j) {
            int lastExpiryInMonths = 0;
            int currentExpiryInMonths = this.capVolMarketData.getExpiryInMonths(0);
            boolean isFirstCaplet = true;
            for (int i = 0; i < this.capVolMarketData.getNumberOfExpiryDates(); ++i) {
                if (isFirstCaplet) {
                    capVolMatrix[0][j] = inputCapletVolMatrix[0][j];
                    if (j + 1 < this.capVolMarketData.getNumberOfStrikes()) {
                        capVolMatrix[0][j + 1] = capVolMatrix[0][j];
                    }
                    isFirstCaplet = false;
                } else {
                    double volaBestPoint;
                    LocalDate localDate = this.discountCurve.getReferenceDate();
                    CapletVolatilitySurface capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, inputCapletVolMatrix, capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                    Schedule schedule = ScheduleGenerator.createScheduleFromConventions(localDate, localDate, localDate.plusMonths(currentExpiryInMonths), frequency, ScheduleGenerator.DaycountConvention.ACT_365, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING, (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(new BusinessdayCalendarExcludingWeekends()), -2, 0);
                    CapShiftedVol cap = new CapShiftedVol(schedule, this.forwardCurve.getName(), this.capVolMarketData.getStrike(j), false, this.discountCurve.getName(), capletVolatilities.getName(), this.capVolMarketData.getShift());
                    double sumCapletPrices = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                    double capPrice = Double.MAX_VALUE;
                    double leftPoint = inputCapletVolMatrix[lastExpiryInMonths / this.capVolMarketData.getUnderlyingTenorInMonths() - 1][j];
                    while (capPrice - sumCapletPrices >= 0.0) {
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, leftPoint /= 1.5, capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        capPrice = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        if (capPrice - sumCapletPrices != 0.0) continue;
                    }
                    double leftValue = capPrice - sumCapletPrices;
                    double rightPoint = leftPoint;
                    while (capPrice - sumCapletPrices <= 0.0) {
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, rightPoint += 0.1, capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        capPrice = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        if (capPrice - sumCapletPrices != 0.0) continue;
                    }
                    double rightValue = capPrice - sumCapletPrices;
                    BisectionSearch bisectionSearch = new BisectionSearch(leftPoint, rightPoint);
                    bisectionSearch.setValue(leftValue);
                    bisectionSearch.setValue(rightValue);
                    while (!bisectionSearch.isDone()) {
                        capletVolatilities = new CapletVolatilitySurface("Cap volatility surface", localDate, bisectionSearch.getNextPoint(), capletFixingTimeVectorInYears, this.capVolMarketData.getStrikeVector(), this.forwardCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
                        capPrice = cap.getValueAsPrice(0.0, this.analyticModel.addVolatilitySurfaces(capletVolatilities));
                        bisectionSearch.setValue(capPrice - sumCapletPrices);
                    }
                    capVolMatrix[i][j] = volaBestPoint = bisectionSearch.getBestPoint();
                }
                lastExpiryInMonths = currentExpiryInMonths;
                if (this.capVolMarketData.getRowIndex(currentExpiryInMonths) + 1 >= this.capVolMarketData.getNumberOfExpiryDates()) continue;
                currentExpiryInMonths = this.capVolMarketData.getExpiryInMonths(this.capVolMarketData.getRowIndex(currentExpiryInMonths) + 1);
            }
        }
        return capVolMatrix;
    }

    public AnalyticModel getParsedModel() {
        return this.analyticModel;
    }

    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    public ForwardCurve getForwardCurve() {
        return this.forwardCurve;
    }

    public double[] getCapletFixingTimeVectorInYears() {
        return this.capletFixingTimeVectorInYears;
    }
}

