/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet;

import java.time.LocalDate;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.model.volatility.caplet.smile.LinearSmileInterpolater;
import net.finmath.time.daycount.DayCountConvention;

public class CapletVolatilitySurface
implements VolatilitySurface {
    private final String name;
    private final LocalDate referenceDate;
    private final VolatilitySurface.QuotingConvention volatilityConvention;
    private final double[][] volatilityMatrix;
    private final double[] maturityVector;
    private final double[] strikeVector;
    private final ForwardCurve forwardCurve;
    private final DiscountCurve discountCurve;
    private final DayCountConvention daycountConvention;

    public CapletVolatilitySurface(String name, LocalDate referenceDate, double[][] volatilityMatrix, double[] maturityVector, double[] strikeVector, ForwardCurve forwardCurve, VolatilitySurface.QuotingConvention volatilityConvention, DiscountCurve discountCurve) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.volatilityMatrix = volatilityMatrix;
        this.maturityVector = maturityVector;
        this.strikeVector = strikeVector;
        this.volatilityConvention = volatilityConvention;
        this.daycountConvention = null;
    }

    public CapletVolatilitySurface(String name, LocalDate referenceDate, double volatility, double[] maturityVector, double[] strikeVector, ForwardCurve forwardCurve, VolatilitySurface.QuotingConvention volatilityConvention, DiscountCurve discountCurve) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.forwardCurve = forwardCurve;
        this.discountCurve = discountCurve;
        this.volatilityMatrix = new double[maturityVector.length][strikeVector.length];
        for (int i = 0; i < maturityVector.length; ++i) {
            for (int j = 0; j < strikeVector.length; ++j) {
                this.volatilityMatrix[i][j] = volatility;
            }
        }
        this.maturityVector = maturityVector;
        this.strikeVector = strikeVector;
        this.volatilityConvention = volatilityConvention;
        this.daycountConvention = null;
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double distance = Math.abs(this.maturityVector[0] - maturity);
        int closestIndex = 0;
        for (int i = 1; i < this.maturityVector.length; ++i) {
            if (!(Math.abs(this.maturityVector[i] - maturity) < distance)) continue;
            closestIndex = i;
            distance = Math.abs(this.maturityVector[i] - maturity);
        }
        LinearSmileInterpolater linearSmileInterpolater = new LinearSmileInterpolater(this.volatilityMatrix, this.strikeVector);
        return linearSmileInterpolater.calculateInterpolatedExtrapolatedSmileVolatility(strike, closestIndex);
    }

    @Override
    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double value;
        if (maturity == 0.0) {
            return 0.0;
        }
        double distance = Math.abs(this.maturityVector[0] - maturity);
        int closestIndex = 0;
        for (int i = 1; i < this.maturityVector.length; ++i) {
            if (!(Math.abs(this.maturityVector[i] - maturity) < distance)) continue;
            closestIndex = i;
            distance = Math.abs(this.maturityVector[i] - maturity);
        }
        if (distance == 0.0) {
            LinearSmileInterpolater linearSmileInterpolater = new LinearSmileInterpolater(this.volatilityMatrix, this.strikeVector);
            value = linearSmileInterpolater.calculateInterpolatedExtrapolatedSmileVolatility(strike, closestIndex);
        } else {
            int maturityGreaterEqualIndex = closestIndex;
            if (maturityGreaterEqualIndex < 0) {
                maturityGreaterEqualIndex = -maturityGreaterEqualIndex - 1;
            }
            if (maturityGreaterEqualIndex > this.maturityVector.length - 1) {
                maturityGreaterEqualIndex = this.maturityVector.length - 1;
            }
            double adjustedStrike = this.getForwardCurve().getValue(model, this.maturityVector[maturityGreaterEqualIndex]) + (strike - this.getForwardCurve().getValue(model, maturity));
            LinearSmileInterpolater linearSmileInterpolater = new LinearSmileInterpolater(this.volatilityMatrix, this.strikeVector);
            value = linearSmileInterpolater.calculateInterpolatedExtrapolatedSmileVolatility(adjustedStrike, maturityGreaterEqualIndex);
        }
        return this.convertFromTo(model, maturity, strike, value, this.getQuotingConvention(), quotingConvention);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public VolatilitySurface.QuotingConvention getQuotingConvention() {
        return this.volatilityConvention;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public ForwardCurve getForwardCurve() {
        return this.forwardCurve;
    }

    public DiscountCurve getDiscountCurve() {
        return this.discountCurve;
    }

    public double convertFromTo(AnalyticModel model, double optionMaturity, double optionStrike, double value, VolatilitySurface.QuotingConvention fromQuotingConvention, VolatilitySurface.QuotingConvention toQuotingConvention) {
        double daycountFraction;
        if (fromQuotingConvention.equals((Object)toQuotingConvention)) {
            return value;
        }
        if (this.discountCurve == null) {
            throw new IllegalArgumentException("Missing discount curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        if (this.forwardCurve == null) {
            throw new IllegalArgumentException("Missing forward curve. Conversion of QuotingConvention requires forward curve and discount curve to be set.");
        }
        double periodStart = optionMaturity;
        double periodEnd = periodStart + this.forwardCurve.getPaymentOffset(periodStart);
        double forward = this.forwardCurve.getForward(model, periodStart);
        if (this.daycountConvention != null) {
            LocalDate startDate = this.referenceDate.plusDays((int)Math.round(periodStart * 365.0));
            LocalDate endDate = this.referenceDate.plusDays((int)Math.round(periodEnd * 365.0));
            daycountFraction = this.daycountConvention.getDaycountFraction(startDate, endDate);
        } else {
            daycountFraction = this.forwardCurve.getPaymentOffset(periodStart);
        }
        double payoffUnit = this.discountCurve.getDiscountFactor(optionMaturity + this.forwardCurve.getPaymentOffset(optionMaturity)) * daycountFraction;
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL)) {
            return AnalyticFormulas.blackScholesGeneralizedOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL)) {
            return AnalyticFormulas.bachelierOptionValue(forward, value, optionMaturity, optionStrike, payoffUnit);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.blackScholesOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        if (toQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.VOLATILITYNORMAL) && fromQuotingConvention.equals((Object)VolatilitySurface.QuotingConvention.PRICE)) {
            return AnalyticFormulas.bachelierOptionImpliedVolatility(forward, optionMaturity, optionStrike, payoffUnit, value);
        }
        return this.convertFromTo(model, optionMaturity, optionStrike, this.convertFromTo(model, optionMaturity, optionStrike, value, fromQuotingConvention, VolatilitySurface.QuotingConvention.PRICE), VolatilitySurface.QuotingConvention.PRICE, toQuotingConvention);
    }

    public double convertFromTo(double optionMaturity, double optionStrike, double value, VolatilitySurface.QuotingConvention fromQuotingConvention, VolatilitySurface.QuotingConvention toQuotingConvention) {
        return this.convertFromTo(null, optionMaturity, optionStrike, value, fromQuotingConvention, toQuotingConvention);
    }
}

