/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet.tenorconversion;

import java.time.LocalDate;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.volatility.caplet.CapVolMarketData;
import net.finmath.marketdata.model.volatility.caplet.CapletVolBootstrapping;
import net.finmath.marketdata.model.volatility.caplet.smile.LinearSmileInterpolater;
import net.finmath.marketdata.model.volatility.caplet.tenorconversion.CorrelationProvider;
import net.finmath.marketdata.products.Swap;
import net.finmath.rootfinder.NewtonsMethod;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;

public class CorrelationProviderTenorBasis
implements CorrelationProvider {
    private final CapVolMarketData iCap3MCapVolMarketData;
    private final CapVolMarketData iCap6MCapVolMarketData;
    private CapletVolBootstrapping iCap3MCapletVolBootrapper;
    private CapletVolBootstrapping iCap6MCapletVolBootrapper;
    private double[][] iCap3MCapletVolMatrix;
    private double[][] iCap6MCapletVolMatrix;
    private double[][] correlationMatrix1M;
    private double[][] correlationMatrix3M;
    private double[][] correlationMatrix6M;

    public CorrelationProviderTenorBasis(CapVolMarketData iCap3MCapVolMarketData, CapVolMarketData iCap6MCapVolMarketData) {
        this.iCap3MCapVolMarketData = iCap3MCapVolMarketData;
        this.iCap6MCapVolMarketData = iCap6MCapVolMarketData;
    }

    public double get6MCorrelation(double firstForwardFixingTimeVectorInYears, double secondForwardFixingTimeVectorInYears, AnalyticModel analyticModel) throws CalculationException {
        return 0.0;
    }

    public double get3MCorrelation(double firstForwardFixingTimeVectorInYears, double secondForwardFixingTimeVectorInYears, AnalyticModel analyticModel) throws CalculationException {
        int i;
        double[] capletFixingTimeVectorInYears = new double[this.iCap3MCapVolMarketData.getMaxExpiryInMonths() / this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths() - 1];
        for (int i2 = 0; i2 < capletFixingTimeVectorInYears.length; ++i2) {
            capletFixingTimeVectorInYears[i2] = (double)((i2 + 1) * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()) / 12.0;
        }
        int rowIndex = 0;
        int columnIndex = 0;
        double distanceToFixingTimeRow = Double.MAX_VALUE;
        double distanceToFixingTimeColumn = Double.MAX_VALUE;
        for (i = 0; i < capletFixingTimeVectorInYears.length; ++i) {
            if (Math.abs(firstForwardFixingTimeVectorInYears - capletFixingTimeVectorInYears[i]) < distanceToFixingTimeRow) {
                rowIndex = i;
                distanceToFixingTimeRow = Math.abs(firstForwardFixingTimeVectorInYears - capletFixingTimeVectorInYears[i]);
            }
            if (!(Math.abs(secondForwardFixingTimeVectorInYears - capletFixingTimeVectorInYears[i]) < distanceToFixingTimeColumn)) continue;
            columnIndex = i;
            distanceToFixingTimeColumn = Math.abs(secondForwardFixingTimeVectorInYears - capletFixingTimeVectorInYears[i]);
        }
        if (this.correlationMatrix3M != null) {
            return this.correlationMatrix3M[rowIndex][columnIndex];
        }
        this.iCap3MCapletVolBootrapper = new CapletVolBootstrapping(this.iCap3MCapVolMarketData, analyticModel);
        this.iCap6MCapletVolBootrapper = new CapletVolBootstrapping(this.iCap6MCapVolMarketData, analyticModel);
        if (this.iCap3MCapletVolMatrix == null || this.iCap6MCapletVolMatrix == null) {
            this.iCap3MCapletVolMatrix = this.iCap3MCapletVolBootrapper.getCapletVolMatrix();
            this.iCap6MCapletVolMatrix = this.iCap6MCapletVolBootrapper.getCapletVolMatrix();
        }
        this.correlationMatrix3M = new double[this.iCap3MCapVolMarketData.getMaxExpiryInMonths() / this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths() - 1][this.iCap3MCapVolMarketData.getMaxExpiryInMonths() / this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths() - 1];
        for (i = 0; i < this.correlationMatrix3M.length; ++i) {
            this.correlationMatrix3M[i][i] = 1.0;
        }
        LinearSmileInterpolater smileInterExtrapolater3M = new LinearSmileInterpolater(this.iCap3MCapletVolMatrix, this.iCap3MCapVolMarketData.getStrikeVector());
        LinearSmileInterpolater smileInterExtrapolater6M = new LinearSmileInterpolater(this.iCap6MCapletVolMatrix, this.iCap6MCapVolMarketData.getStrikeVector());
        double[][] K = new double[this.correlationMatrix3M.length / 2 - (1 - this.correlationMatrix3M.length % 2)][2];
        double[][] nu = new double[this.correlationMatrix3M.length / 2 - (1 - this.correlationMatrix3M.length % 2)][2];
        double[] sumNu = new double[this.correlationMatrix3M.length / 2 - (1 - this.correlationMatrix3M.length % 2)];
        for (int i3 = 0; i3 < this.correlationMatrix3M.length / 2 - (1 - this.correlationMatrix3M.length % 2); ++i3) {
            int k;
            LocalDate localDate = this.iCap3MCapletVolBootrapper.getDiscountCurve().getReferenceDate();
            Schedule schedule3M = ScheduleGenerator.createScheduleFromConventions(localDate, localDate.plusMonths(2 * (i3 + 1) * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()), localDate.plusMonths(2 * (i3 + 2) * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()), ScheduleGenerator.Frequency.QUARTERLY, ScheduleGenerator.DaycountConvention.ACT_365, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING, (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(new BusinessdayCalendarExcludingWeekends()), -2, 0);
            Schedule schedule6M = ScheduleGenerator.createScheduleFromConventions(localDate, localDate.plusMonths(2 * (i3 + 1) * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()), localDate.plusMonths(2 * (i3 + 2) * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()), ScheduleGenerator.Frequency.SEMIANNUAL, ScheduleGenerator.DaycountConvention.ACT_365, ScheduleGenerator.ShortPeriodConvention.FIRST, BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING, (BusinessdayCalendar)new BusinessdayCalendarExcludingTARGETHolidays(new BusinessdayCalendarExcludingWeekends()), -2, 0);
            double strikeATM = Swap.getForwardSwapRate(schedule3M, schedule3M, this.iCap3MCapletVolBootrapper.getForwardCurve(), this.iCap3MCapletVolBootrapper.getParsedModel());
            double[] shortTenorTau = new double[nu[0].length];
            for (int k2 = 0; k2 < shortTenorTau.length; ++k2) {
                shortTenorTau[k2] = schedule3M.getPeriodLength(k2);
            }
            double longTenorTau = schedule6M.getPeriodLength(0);
            for (k = 0; k < nu[0].length; ++k) {
                nu[i3][k] = shortTenorTau[k] * (1.0 + longTenorTau * this.iCap6MCapletVolBootrapper.getForwardCurve().getForward(this.iCap6MCapletVolBootrapper.getParsedModel(), capletFixingTimeVectorInYears[i3 * 2 + 1])) / (longTenorTau * (1.0 + shortTenorTau[k] * this.iCap3MCapletVolBootrapper.getForwardCurve().getForward(this.iCap3MCapletVolBootrapper.getParsedModel(), capletFixingTimeVectorInYears[i3 * 2 + 1] + schedule3M.getPeriodStart(k))));
                int n = i3;
                sumNu[n] = sumNu[n] + nu[i3][k];
            }
            for (k = 0; k < K[0].length; ++k) {
                K[i3][k] = (strikeATM - (this.iCap6MCapletVolBootrapper.getForwardCurve().getForward(this.iCap6MCapletVolBootrapper.getParsedModel(), capletFixingTimeVectorInYears[i3 * 2 + 1]) - sumNu[i3] * this.iCap3MCapletVolBootrapper.getForwardCurve().getForward(this.iCap3MCapletVolBootrapper.getParsedModel(), capletFixingTimeVectorInYears[i3 * 2 + 1] + (double)(k * this.iCap3MCapVolMarketData.getUnderlyingTenorInMonths()) / 12.0))) / sumNu[i3];
            }
            double guess = 1.0;
            NewtonsMethod newtonsMethod = new NewtonsMethod(1.0);
            double derivativeSumToMinimize = 0.0;
            double secondDerivativeSumToMinimize = 0.0;
            double rightHandSideSum = 0.0;
            double derivativeRightHandSideSum = 0.0;
            for (int k1 = 0; k1 < 2; ++k1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    if (k1 == k2) {
                        rightHandSideSum += nu[i3][k1] * nu[i3][k2] * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k1], i3 * 2 + 1 + k1) * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k2], i3 * 2 + 1 + k2);
                        continue;
                    }
                    rightHandSideSum += nu[i3][k1] * nu[i3][k2] * 1.0 * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k1], i3 * 2 + 1 + k1) * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k2], i3 * 2 + 1 + k2);
                    derivativeRightHandSideSum += nu[i3][k1] * nu[i3][k2] * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k1], i3 * 2 + 1 + k1) * smileInterExtrapolater3M.calculateInterpolatedExtrapolatedSmileVolatility(K[i3][k2], i3 * 2 + 1 + k2);
                }
            }
            newtonsMethod.setValueAndDerivative(derivativeSumToMinimize += 2.0 * (smileInterExtrapolater6M.calculateInterpolatedExtrapolatedSmileVolatility(strikeATM, i3) * smileInterExtrapolater6M.calculateInterpolatedExtrapolatedSmileVolatility(strikeATM, i3) - rightHandSideSum) * -derivativeRightHandSideSum, secondDerivativeSumToMinimize += 2.0 * derivativeRightHandSideSum * derivativeRightHandSideSum);
            this.correlationMatrix3M[i3 * 2 + 1][i3 * 2 + 2] = newtonsMethod.getNextPoint();
            this.correlationMatrix3M[i3 * 2 + 2][i3 * 2 + 1] = newtonsMethod.getNextPoint();
        }
        return this.correlationMatrix3M[rowIndex][columnIndex];
    }

    double get1MCorrelation(double firstForwardFixingTimeVectorInYears, double secondForwardFixingTimeVectorInYears, AnalyticModel analyticModel) {
        return 0.0;
    }

    public double[][] getiCap3MCapletVolMatrix() {
        return this.iCap3MCapletVolMatrix;
    }

    public double[][] getiCap6MCapletVolMatrix() {
        return this.iCap6MCapletVolMatrix;
    }

    public double[][] getCorrelationMatrix3M() {
        return this.correlationMatrix3M;
    }

    public double[][] getCorrelationMatrix6M() {
        return this.correlationMatrix6M;
    }

    public CapletVolBootstrapping getICap3MCapletVolBootrapper() {
        return this.iCap3MCapletVolBootrapper;
    }

    public CapletVolBootstrapping getICap6MCapletVolBootrapper() {
        return this.iCap6MCapletVolBootrapper;
    }

    @Override
    public double getCorrelation(int oldTenor, double firstForwardFixingTimeVectorInYears, double secondForwardFixingTimeVectorInYears, AnalyticModel analyticModel, String indexForDiscount) throws CalculationException {
        if (oldTenor == 6) {
            return this.get6MCorrelation(firstForwardFixingTimeVectorInYears, secondForwardFixingTimeVectorInYears, analyticModel);
        }
        if (oldTenor == 3) {
            return this.get3MCorrelation(firstForwardFixingTimeVectorInYears, secondForwardFixingTimeVectorInYears, analyticModel);
        }
        if (oldTenor == 1) {
            return this.get1MCorrelation(firstForwardFixingTimeVectorInYears, secondForwardFixingTimeVectorInYears, analyticModel);
        }
        throw new IllegalArgumentException("Wrong Tenor for the iCap correlation provider");
    }
}

