/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet.tenorconversion;

import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.model.volatility.caplet.CapTenorStructure;
import net.finmath.marketdata.model.volatility.caplet.CapletVolatilitySurface;
import net.finmath.marketdata.model.volatility.caplet.tenorconversion.CorrelationProvider;

public class TenorConverter {
    private final int currentTenorInMonths;
    private final int newTenorInMonths;
    private final double[] capletFixingTimeVectorInYears;
    private final double[] strikeVector;
    private final double[][] capletVolatilities;
    private final CapletVolatilitySurface capletVolatilitySurface;
    private final CorrelationProvider correlationProvider;
    private final DiscountCurve discountCurve;
    private final DiscountCurve discountForForwardCurveOldTenor;
    private final DiscountCurve discountForForwardCurveNewTenor;
    private final ForwardCurve forwardCurveOldTenor;
    private final ForwardCurve forwardCurveNewTenor;
    private final String indexForDiscount;
    private final String indexOldTenor;
    private final String indexNewTenor;
    private transient AnalyticModel analyticModel;

    public TenorConverter(CorrelationProvider correlationProvider, int currentTenorInMonths, int newTenorInMonths, double[] capletFixingTimeVectorInYears, double[] strikeVector, double[][] capletVolatilities, CapTenorStructure capTenorStructure, AnalyticModel analyticModel2, String indexForDiscount, String indexOldTenor, String indexNewTenor) {
        this.currentTenorInMonths = currentTenorInMonths;
        this.newTenorInMonths = newTenorInMonths;
        this.capletFixingTimeVectorInYears = capletFixingTimeVectorInYears;
        this.strikeVector = strikeVector;
        this.capletVolatilities = capletVolatilities;
        this.correlationProvider = correlationProvider;
        this.indexForDiscount = indexForDiscount;
        this.indexOldTenor = indexOldTenor;
        this.indexNewTenor = indexNewTenor;
        String currency = null;
        switch (capTenorStructure) {
            case EUR: {
                currency = "EUR";
                break;
            }
            case USD: {
                currency = "USD";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown currency " + (Object)((Object)capTenorStructure) + ".");
            }
        }
        this.analyticModel = analyticModel2;
        this.discountCurve = analyticModel2.getDiscountCurve(currency + "_" + indexForDiscount);
        this.discountForForwardCurveOldTenor = null;
        this.discountForForwardCurveNewTenor = null;
        this.forwardCurveOldTenor = this.analyticModel.getForwardCurve("Forward_" + currency + "_" + indexNewTenor);
        this.forwardCurveNewTenor = this.analyticModel.getForwardCurve("Forward_" + currency + "_" + indexNewTenor);
        this.capletVolatilitySurface = new CapletVolatilitySurface("Tenor " + this.currentTenorInMonths + " Months", this.discountCurve.getReferenceDate(), this.capletVolatilities, this.capletFixingTimeVectorInYears, this.strikeVector, this.forwardCurveOldTenor, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, this.discountCurve);
    }

    public double[][] convertTenor() throws CalculationException {
        int k2;
        int k1;
        int k;
        int i;
        double[] newCapletFixingTimeVectorInYears;
        int n;
        if (this.currentTenorInMonths == this.newTenorInMonths) {
            throw new CalculationException("old and new tenor collide.");
        }
        double[][] newCapletVolatilities = null;
        if (this.currentTenorInMonths < this.newTenorInMonths) {
            if (this.newTenorInMonths % this.currentTenorInMonths != 0) {
                throw new CalculationException("The new tenor has to be divisible by the old tenor or the other way round.");
            }
            n = this.newTenorInMonths / this.currentTenorInMonths;
            newCapletFixingTimeVectorInYears = new double[(this.capletFixingTimeVectorInYears.length + 1) / n - 1];
            for (int i2 = 0; i2 < newCapletFixingTimeVectorInYears.length; ++i2) {
                newCapletFixingTimeVectorInYears[i2] = this.capletFixingTimeVectorInYears[n - 1 + n * i2];
            }
            newCapletVolatilities = new double[(this.capletFixingTimeVectorInYears.length + 1) / n - 1][this.strikeVector.length];
            for (int j = 0; j < this.strikeVector.length; ++j) {
                for (i = 0; i < newCapletFixingTimeVectorInYears.length; ++i) {
                    double[] nu = new double[n];
                    double sumNu = 0.0;
                    double[] K = new double[n];
                    for (k = 0; k < n; ++k) {
                        nu[k] = (double)this.currentTenorInMonths * (1.0 + (double)this.newTenorInMonths / 12.0 * this.forwardCurveNewTenor.getForward(this.analyticModel, newCapletFixingTimeVectorInYears[i])) / ((double)this.newTenorInMonths * (1.0 + (double)this.currentTenorInMonths / 12.0 * this.forwardCurveOldTenor.getForward(this.analyticModel, newCapletFixingTimeVectorInYears[i] + (double)(k * this.currentTenorInMonths) / 12.0)));
                        sumNu += nu[k];
                    }
                    for (k = 0; k < n; ++k) {
                        K[k] = (this.strikeVector[j] - (this.forwardCurveNewTenor.getForward(this.analyticModel, newCapletFixingTimeVectorInYears[i]) - sumNu * this.forwardCurveOldTenor.getForward(this.analyticModel, newCapletFixingTimeVectorInYears[i] + (double)(k * this.currentTenorInMonths) / 12.0))) / sumNu;
                    }
                    for (k1 = 0; k1 < n; ++k1) {
                        for (k2 = 0; k2 < n; ++k2) {
                            double[] dArray = newCapletVolatilities[i];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + nu[k1] * nu[k2] * this.correlationProvider.getCorrelation(this.currentTenorInMonths, newCapletFixingTimeVectorInYears[i] + (double)(k1 * this.currentTenorInMonths) / 12.0, newCapletFixingTimeVectorInYears[i] + (double)(k2 * this.currentTenorInMonths) / 12.0, this.analyticModel, this.indexForDiscount) * this.capletVolatilitySurface.getValue(this.analyticModel, newCapletFixingTimeVectorInYears[i] + (double)(k1 * this.currentTenorInMonths) / 12.0, K[k1], VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) * this.capletVolatilitySurface.getValue(this.analyticModel, newCapletFixingTimeVectorInYears[i] + (double)(k2 * this.currentTenorInMonths) / 12.0, K[k2], VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL);
                        }
                    }
                    newCapletVolatilities[i][j] = Math.sqrt(newCapletVolatilities[i][j]);
                }
            }
        }
        if (this.currentTenorInMonths > this.newTenorInMonths) {
            if (this.currentTenorInMonths % this.newTenorInMonths != 0) {
                throw new CalculationException("The new tenor has to be divisible by the old tenor or the other way round.");
            }
            n = this.currentTenorInMonths / this.newTenorInMonths;
            newCapletFixingTimeVectorInYears = new double[(this.capletFixingTimeVectorInYears.length + 1) * n - 1];
            double[] firstLongCapletFixingTimeVectorInYears = new double[(this.capletFixingTimeVectorInYears.length + 1) * n - 1];
            for (i = 0; i < newCapletFixingTimeVectorInYears.length; i += n) {
                newCapletFixingTimeVectorInYears[i] = this.capletFixingTimeVectorInYears[0] / (double)n * (double)(i + 1);
                firstLongCapletFixingTimeVectorInYears[i] = i < n - 1 ? this.capletFixingTimeVectorInYears[0] : this.capletFixingTimeVectorInYears[(i + 1) / n - 1];
            }
            newCapletVolatilities = new double[(this.capletFixingTimeVectorInYears.length + 1) * n - 1][this.strikeVector.length];
            for (int j = 0; j < this.strikeVector.length; ++j) {
                for (int i3 = 0; i3 < newCapletFixingTimeVectorInYears.length; ++i3) {
                    double[] nu = new double[n];
                    double sumNuNuRho = 0.0;
                    for (k = 0; k < n; ++k) {
                        nu[k] = (double)this.newTenorInMonths * (1.0 + (double)this.currentTenorInMonths / 12.0 * this.forwardCurveNewTenor.getForward(this.analyticModel, firstLongCapletFixingTimeVectorInYears[i3])) / ((double)this.newTenorInMonths * (1.0 + (double)this.currentTenorInMonths / 12.0 * this.forwardCurveOldTenor.getForward(this.analyticModel, firstLongCapletFixingTimeVectorInYears[i3] + (double)(k * this.currentTenorInMonths) / 12.0)));
                    }
                    for (k1 = 0; k1 < n; ++k1) {
                        for (k2 = 0; k2 < n; ++k2) {
                            sumNuNuRho += nu[k1] * nu[k2] * this.correlationProvider.getCorrelation(this.newTenorInMonths, firstLongCapletFixingTimeVectorInYears[i3] + (double)(k1 * this.newTenorInMonths) / 12.0, firstLongCapletFixingTimeVectorInYears[i3] + (double)(k2 * this.newTenorInMonths) / 12.0, this.analyticModel, this.indexForDiscount);
                        }
                    }
                    newCapletVolatilities[i3][j] = i3 < n - 1 ? this.capletVolatilitySurface.getValue(this.analyticModel, firstLongCapletFixingTimeVectorInYears[0], this.strikeVector[j], VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) / Math.sqrt(sumNuNuRho) : this.capletVolatilitySurface.getValue(this.analyticModel, firstLongCapletFixingTimeVectorInYears[i3], this.strikeVector[j], VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) / Math.sqrt(sumNuNuRho);
                }
            }
        }
        return newCapletVolatilities;
    }
}

