/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.CapletVolatilities;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.optimizer.GoldenSectionSearch;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleFromPeriods;

public class Cap
extends AbstractAnalyticProduct {
    private final Schedule schedule;
    private final String forwardCurveName;
    private final double strike;
    private final boolean isStrikeMoneyness;
    private final String discountCurveName;
    private final String volatiltiySufaceName;
    private final VolatilitySurface.QuotingConvention quotingConvention;
    private transient double cachedATMForward = Double.NaN;
    private transient SoftReference<AnalyticModel> cacheStateModel;
    private transient boolean cacheStateIsFirstPeriodIncluded;

    public Cap(Schedule schedule, String forwardCurveName, double strike, boolean isStrikeMoneyness, String discountCurveName, String volatilitySurfaceName, VolatilitySurface.QuotingConvention quotingConvention) {
        this.schedule = schedule;
        this.forwardCurveName = forwardCurveName;
        this.strike = strike;
        this.isStrikeMoneyness = isStrikeMoneyness;
        this.discountCurveName = discountCurveName;
        this.volatiltiySufaceName = volatilitySurfaceName;
        this.quotingConvention = quotingConvention;
    }

    public Cap(Schedule schedule, String forwardCurveName, double strike, boolean isStrikeMoneyness, String discountCurveName, String volatilitySurfaceName) {
        this(schedule, forwardCurveName, strike, isStrikeMoneyness, discountCurveName, volatilitySurfaceName, VolatilitySurface.QuotingConvention.PRICE);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        if (this.quotingConvention == VolatilitySurface.QuotingConvention.PRICE) {
            return this.getValueAsPrice(evaluationTime, model);
        }
        return this.getImpliedVolatility(evaluationTime, model, this.quotingConvention);
    }

    public double getValueAsPrice(double evaluationTime, AnalyticModel model) {
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        DiscountCurve discountCurveForForward = null;
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveForForward = model.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double volatility;
            VolatilitySurface volatilitySurface;
            double fixingDate = this.schedule.getFixing(periodIndex);
            double paymentDate = this.schedule.getPayment(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            double forward = 0.0;
            if (forwardCurve != null) {
                forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
            } else if (discountCurveForForward != null && fixingDate != paymentDate) {
                forward += (discountCurveForForward.getDiscountFactor(fixingDate) / discountCurveForForward.getDiscountFactor(paymentDate) - 1.0) / (paymentDate - fixingDate);
            }
            double discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            double payoffUnit = discountFactor * periodLength;
            double effektiveStrike = this.strike;
            if (this.isStrikeMoneyness) {
                effektiveStrike += this.getATMForward(model, true);
            }
            if ((volatilitySurface = model.getVolatilitySurface(this.volatiltiySufaceName)) == null) {
                throw new IllegalArgumentException("Volatility surface not found in model: " + this.volatiltiySufaceName);
            }
            if (volatilitySurface.getQuotingConvention() == VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) {
                volatility = volatilitySurface.getValue(model, fixingDate, effektiveStrike, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL);
                value += AnalyticFormulas.blackScholesGeneralizedOptionValue(forward, volatility, fixingDate, effektiveStrike, payoffUnit);
                continue;
            }
            volatility = volatilitySurface.getValue(model, fixingDate, effektiveStrike, VolatilitySurface.QuotingConvention.VOLATILITYNORMAL);
            value += AnalyticFormulas.bachelierOptionValue(forward, volatility, fixingDate, effektiveStrike, payoffUnit);
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public double getATMForward(AnalyticModel model, boolean isFirstPeriodIncluded) {
        if (!Double.isNaN(this.cachedATMForward) && this.cacheStateModel.get() == model && this.cacheStateIsFirstPeriodIncluded == isFirstPeriodIncluded) {
            return this.cachedATMForward;
        }
        Schedule remainderSchedule = this.schedule;
        if (!isFirstPeriodIncluded) {
            ArrayList<Period> periods = new ArrayList<Period>();
            periods.addAll(this.schedule.getPeriods());
            if (periods.size() > 1) {
                periods.remove(0);
            }
            remainderSchedule = new ScheduleFromPeriods(this.schedule.getReferenceDate(), periods, this.schedule.getDaycountconvention());
        }
        SwapLeg floatLeg = new SwapLeg(remainderSchedule, this.forwardCurveName, 0.0, this.discountCurveName, false);
        SwapLeg annuityLeg = new SwapLeg(remainderSchedule, null, 1.0, this.discountCurveName, false);
        this.cachedATMForward = floatLeg.getValue(model) / annuityLeg.getValue(model);
        this.cacheStateModel = new SoftReference<AnalyticModel>(model);
        this.cacheStateIsFirstPeriodIncluded = isFirstPeriodIncluded;
        return this.cachedATMForward;
    }

    public double getImpliedVolatility(double evaluationTime, AnalyticModel model, VolatilitySurface.QuotingConvention quotingConvention) {
        double lowerBound = Double.MAX_VALUE;
        double upperBound = -1.7976931348623157E308;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = this.schedule.getFixing(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            double effektiveStrike = this.strike;
            if (this.isStrikeMoneyness) {
                effektiveStrike += this.getATMForward(model, true);
            }
            VolatilitySurface volatilitySurface = model.getVolatilitySurface(this.volatiltiySufaceName);
            double volatility = volatilitySurface.getValue(model, fixingDate, effektiveStrike, quotingConvention);
            lowerBound = Math.min(volatility, lowerBound);
            upperBound = Math.max(volatility, upperBound);
        }
        double value = this.getValueAsPrice(evaluationTime, model);
        int maxIterations = 100;
        double maxAccuracy = 0.0;
        GoldenSectionSearch solver = new GoldenSectionSearch(lowerBound, upperBound);
        while (solver.getAccuracy() > 0.0 && !solver.isDone() && solver.getNumberOfIterations() < 100) {
            double volatility = solver.getNextPoint();
            double[] maturities = new double[]{1.0};
            double[] strikes = new double[]{0.0};
            double[] volatilities = new double[]{volatility};
            CapletVolatilities flatSurface = new CapletVolatilities(model.getVolatilitySurface(this.volatiltiySufaceName).getName(), model.getVolatilitySurface(this.volatiltiySufaceName).getReferenceDate(), model.getForwardCurve(this.forwardCurveName), maturities, strikes, volatilities, quotingConvention, model.getDiscountCurve(this.discountCurveName));
            AnalyticModel flatModel = model.clone();
            flatModel = flatModel.addVolatilitySurfaces(flatSurface);
            double flatModelValue = this.getValueAsPrice(evaluationTime, flatModel);
            double error = value - flatModelValue;
            solver.setValue(error * error);
        }
        return solver.getBestPoint();
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getStrike() {
        return this.strike;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public String toString() {
        return "Cap [schedule=" + this.schedule + ", forwardCurveName=" + this.forwardCurveName + ", strike=" + this.strike + ", discountCurveName=" + this.discountCurveName + ", volatiltiySufaceName=" + this.volatiltiySufaceName + "]";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.cachedATMForward = Double.NaN;
    }
}

