/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.time.Schedule;

public class ForwardRateAgreement
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private final boolean isPayer;

    public ForwardRateAgreement(Schedule schedule, double spread, String forwardCurveName, String discountCurveName, boolean isPayer) {
        this.schedule = schedule;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
        this.isPayer = isPayer;
        if (schedule.getNumberOfPeriods() > 1) {
            throw new IllegalArgumentException("Number of periods has to be 1: Change frequency to 'tenor'!");
        }
    }

    public ForwardRateAgreement(Schedule schedule, double spread, String forwardCurveName, String discountCurveName) {
        this(schedule, spread, forwardCurveName, discountCurveName, true);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double fixingDate = this.schedule.getFixing(0);
        double paymentDate = this.schedule.getPayment(0);
        double periodLength = this.schedule.getPeriodLength(0);
        double forward = 0.0;
        if (forwardCurve != null) {
            forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
        }
        double notional = this.isPayer ? 1.0 : -1.0;
        double discountFactorFixingDate = fixingDate > evaluationTime ? discountCurve.getDiscountFactor(model, fixingDate) : 0.0;
        return notional * (forward - this.spread) / (1.0 + forward * periodLength) * discountFactorFixingDate * periodLength;
    }

    public double getRate(AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null) {
            throw new IllegalArgumentException("No forward curve of name '" + this.forwardCurveName + "' found in given model:\n" + model.toString());
        }
        double fixingDate = this.schedule.getFixing(0);
        return forwardCurve.getForward(model, fixingDate);
    }
}

