/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.io.Serializable;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.InterestRateProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;

public class Swap
extends AbstractAnalyticProduct
implements AnalyticProduct,
DescribedProduct<InterestRateSwapProductDescriptor>,
Serializable {
    private static final long serialVersionUID = 6546984174616265190L;
    private final AnalyticProduct legReceiver;
    private final AnalyticProduct legPayer;

    public Swap(AnalyticProduct legReceiver, AnalyticProduct legPayer) {
        this.legReceiver = legReceiver;
        this.legPayer = legPayer;
    }

    public Swap(Schedule scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, Schedule schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName, boolean isNotionalExchanged) {
        this.legReceiver = new SwapLeg(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, isNotionalExchanged);
        this.legPayer = new SwapLeg(schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, isNotionalExchanged);
    }

    public Swap(Schedule scheduleReceiveLeg, String forwardCurveReceiveName, double spreadReceive, String discountCurveReceiveName, Schedule schedulePayLeg, String forwardCurvePayName, double spreadPay, String discountCurvePayName) {
        this(scheduleReceiveLeg, forwardCurveReceiveName, spreadReceive, discountCurveReceiveName, schedulePayLeg, forwardCurvePayName, spreadPay, discountCurvePayName, true);
    }

    public Swap(Schedule scheduleReceiveLeg, double spreadReceive, String discountCurveReceiveName, Schedule schedulePayLeg, String forwardCurvePayName, String discountCurvePayName) {
        this(scheduleReceiveLeg, null, spreadReceive, discountCurveReceiveName, schedulePayLeg, forwardCurvePayName, 0.0, discountCurvePayName, true);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        double valueReceiverLeg = this.legReceiver.getValue(evaluationTime, model);
        double valuePayerLeg = this.legPayer.getValue(evaluationTime, model);
        return valueReceiverLeg - valuePayerLeg;
    }

    public static double getForwardSwapRate(TimeDiscretization fixTenor, TimeDiscretization floatTenor, ForwardCurve forwardCurve) {
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve);
    }

    public static double getForwardSwapRate(TimeDiscretization fixTenor, TimeDiscretization floatTenor, ForwardCurve forwardCurve, DiscountCurve discountCurve) {
        AnalyticModelFromCurvesAndVols model = null;
        if (discountCurve != null) {
            model = new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve});
        }
        return Swap.getForwardSwapRate(new RegularSchedule(fixTenor), new RegularSchedule(floatTenor), forwardCurve, model);
    }

    public static double getForwardSwapRate(Schedule fixSchedule, Schedule floatSchedule, ForwardCurve forwardCurve) {
        return Swap.getForwardSwapRate(fixSchedule, floatSchedule, forwardCurve, null);
    }

    public static double getForwardSwapRate(Schedule fixSchedule, Schedule floatSchedule, ForwardCurve forwardCurve, AnalyticModel model) {
        DiscountCurve discountCurve;
        DiscountCurve discountCurve2 = discountCurve = model == null ? null : model.getDiscountCurve(forwardCurve.getDiscountCurveName());
        if (discountCurve == null) {
            discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
            model = new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve});
        }
        double evaluationTime = fixSchedule.getFixing(0);
        double swapAnnuity = SwapAnnuity.getSwapAnnuity(evaluationTime, fixSchedule, discountCurve, model);
        double floatLeg = 0.0;
        for (int periodIndex = 0; periodIndex < floatSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixing = floatSchedule.getFixing(periodIndex);
            double payment = floatSchedule.getPayment(periodIndex);
            double periodLength = floatSchedule.getPeriodLength(periodIndex);
            double forward = forwardCurve.getForward(model, fixing, payment - fixing);
            double discountFactor = discountCurve.getDiscountFactor(model, payment);
            floatLeg += forward * periodLength * discountFactor;
        }
        double valueFloatLeg = floatLeg / discountCurve.getDiscountFactor(model, evaluationTime);
        double swapRate = valueFloatLeg / swapAnnuity;
        return swapRate;
    }

    public AnalyticProduct getLegReceiver() {
        return this.legReceiver;
    }

    public AnalyticProduct getLegPayer() {
        return this.legPayer;
    }

    public String toString() {
        return "Swap [legReceiver=" + this.legReceiver + ", legPayer=" + this.legPayer + "]";
    }

    @Override
    public InterestRateSwapProductDescriptor getDescriptor() {
        if (!(this.legReceiver instanceof DescribedProduct) || !(this.legPayer instanceof DescribedProduct)) {
            throw new RuntimeException("One or both of the legs of this swap do not support extraction of a descriptor.");
        }
        InterestRateProductDescriptor receiverDescriptor = (InterestRateProductDescriptor)((DescribedProduct)((Object)this.legReceiver)).getDescriptor();
        InterestRateProductDescriptor payerDescriptor = (InterestRateProductDescriptor)((DescribedProduct)((Object)this.legPayer)).getDescriptor();
        return new InterestRateSwapProductDescriptor(receiverDescriptor, payerDescriptor);
    }
}

