/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;

public class SwapAnnuity
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String discountCurveName;

    public SwapAnnuity(Schedule schedule, String discountCurveName) {
        this.schedule = schedule;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        DiscountCurve discountCurve = (DiscountCurve)model.getCurve(this.discountCurveName);
        return SwapAnnuity.getSwapAnnuity(evaluationTime, this.schedule, discountCurve, model);
    }

    public static double getSwapAnnuity(TimeDiscretization tenor, DiscountCurve discountCurve) {
        return SwapAnnuity.getSwapAnnuity((Schedule)new RegularSchedule(tenor), discountCurve);
    }

    public static double getSwapAnnuity(TimeDiscretization tenor, ForwardCurve forwardCurve) {
        return SwapAnnuity.getSwapAnnuity((Schedule)new RegularSchedule(tenor), forwardCurve);
    }

    public static double getSwapAnnuity(Schedule schedule, DiscountCurve discountCurve) {
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(0.0, schedule, discountCurve, null);
    }

    public static double getSwapAnnuity(Schedule schedule, ForwardCurve forwardCurve) {
        DiscountCurveFromForwardCurve discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(0.0, schedule, discountCurve, new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve}));
    }

    public static double getSwapAnnuity(double evaluationTime, Schedule schedule, DiscountCurve discountCurve, AnalyticModel model) {
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < schedule.getNumberOfPeriods(); ++periodIndex) {
            double paymentDate = schedule.getPayment(periodIndex);
            if (paymentDate <= evaluationTime) continue;
            double periodLength = schedule.getPeriodLength(periodIndex);
            double discountFactor = discountCurve.getDiscountFactor(model, paymentDate);
            value += periodLength * discountFactor;
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public String toString() {
        return "SwapAnnuity [schedule=" + this.schedule + ", discountCurveName=" + this.discountCurveName + "]";
    }
}

