/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Optional;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Schedule;

public class SwapLeg
extends AbstractAnalyticProduct
implements AnalyticProduct,
DescribedProduct<InterestRateSwapLegProductDescriptor>,
Serializable {
    private static final long serialVersionUID = 8311623431369392396L;
    private final LocalDateTime cashFlowEffectiveDate;
    private final Schedule legSchedule;
    private final String forwardCurveName;
    private final String discountCurveName;
    private final String discountCurveForNotionalResetName;
    private boolean isNotionalExchanged = false;
    private final double[] notionals;
    private final double[] spreads;

    public SwapLeg(LocalDateTime cashFlowEffectiveDate, Schedule legSchedule, String forwardCurveName, double[] notionals, double[] spreads, String discountCurveName, boolean isNotionalExchanged) {
        this.cashFlowEffectiveDate = cashFlowEffectiveDate;
        this.legSchedule = legSchedule;
        this.forwardCurveName = forwardCurveName;
        this.spreads = spreads;
        this.discountCurveName = discountCurveName;
        this.discountCurveForNotionalResetName = discountCurveName;
        this.isNotionalExchanged = isNotionalExchanged;
        this.notionals = notionals;
    }

    @Deprecated
    public SwapLeg(Optional<LocalDateTime> cashFlowEffectiveDate, Schedule legSchedule, String forwardCurveName, double[] notionals, double[] spreads, String discountCurveName, boolean isNotionalExchanged) {
        this((LocalDateTime)cashFlowEffectiveDate.orElse(null), legSchedule, forwardCurveName, notionals, spreads, discountCurveName, isNotionalExchanged);
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double[] notionals, double[] spreads, String discountCurveName, boolean isNotionalExchanged) {
        this((LocalDateTime)null, legSchedule, forwardCurveName, notionals, spreads, discountCurveName, isNotionalExchanged);
    }

    public SwapLeg(Optional<LocalDateTime> cashFlowEffectiveDate, Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName, String discountCurveForNotionalResetName, boolean isNotionalExchanged) {
        this.cashFlowEffectiveDate = cashFlowEffectiveDate.orElse(null);
        this.legSchedule = legSchedule;
        this.forwardCurveName = forwardCurveName;
        this.discountCurveName = discountCurveName;
        this.discountCurveForNotionalResetName = discountCurveForNotionalResetName == "" ? discountCurveName : discountCurveForNotionalResetName;
        this.isNotionalExchanged = isNotionalExchanged;
        double[] notionals = new double[legSchedule.getNumberOfPeriods()];
        Arrays.fill(notionals, 1.0);
        this.notionals = notionals;
        double[] spreads = new double[legSchedule.getNumberOfPeriods()];
        Arrays.fill(spreads, spread);
        this.spreads = spreads;
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName, String discountCurveForNotionalResetName, boolean isNotionalExchanged) {
        this(Optional.empty(), legSchedule, forwardCurveName, spread, discountCurveName, discountCurveForNotionalResetName, isNotionalExchanged);
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName, boolean isNotionalExchanged) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, discountCurveName, isNotionalExchanged);
    }

    public SwapLeg(Optional<LocalDateTime> cashFlowEffectiveDate, Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName) {
        this(cashFlowEffectiveDate, legSchedule, forwardCurveName, spread, discountCurveName, discountCurveName, false);
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, discountCurveName, false);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurve discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        double productToModelTimeOffset = 0.0;
        LocalDate modelReferenceDate = discountCurve.getReferenceDate();
        LocalDate productRefereceDate = this.legSchedule.getReferenceDate();
        if (productRefereceDate != null && modelReferenceDate != null) {
            productToModelTimeOffset = FloatingpointDate.getFloatingPointDateFromDate(modelReferenceDate, productRefereceDate);
        }
        DiscountCurve discountCurveForNotionalReset = null;
        if (this.discountCurveForNotionalResetName != null && (discountCurveForNotionalReset = model.getDiscountCurve(this.discountCurveForNotionalResetName)) == null) {
            throw new IllegalArgumentException("No discountCurveForNotionalReset with name '" + this.discountCurveForNotionalResetName + "' was found in the model:\n" + model.toString());
        }
        ForwardCurve forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double cashFlowEffectiveTime = this.cashFlowEffectiveDate != null ? FloatingpointDate.getFloatingPointDateFromDate(LocalDateTime.of(modelReferenceDate, LocalTime.of(0, 0)), this.cashFlowEffectiveDate) : evaluationTime;
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double notional;
            double fixingDate = productToModelTimeOffset + this.legSchedule.getFixing(periodIndex);
            double periodStart = productToModelTimeOffset + this.legSchedule.getPeriodStart(periodIndex);
            double periodEnd = productToModelTimeOffset + this.legSchedule.getPeriodEnd(periodIndex);
            double paymentDate = productToModelTimeOffset + this.legSchedule.getPayment(periodIndex);
            double periodLength = this.legSchedule.getPeriodLength(periodIndex);
            double forward = this.spreads[periodIndex];
            if (forwardCurve != null) {
                forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
            }
            double d = notional = this.notionals != null ? this.notionals[periodIndex] : 1.0;
            if (discountCurveForNotionalReset != null && discountCurveForNotionalReset != discountCurve) {
                notional *= discountCurveForNotionalReset.getDiscountFactor(model, periodStart) / discountCurve.getDiscountFactor(model, periodStart);
            }
            double discountFactor = paymentDate > cashFlowEffectiveTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            value += notional * forward * periodLength * discountFactor;
            if (!this.isNotionalExchanged) continue;
            value += periodEnd > cashFlowEffectiveTime ? notional * discountCurve.getDiscountFactor(model, periodEnd) : 0.0;
            value -= periodStart > cashFlowEffectiveTime ? notional * discountCurve.getDiscountFactor(model, periodStart) : 0.0;
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public Schedule getSchedule() {
        return this.legSchedule;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double[] getSpreads() {
        return (double[])this.spreads.clone();
    }

    public double getSpread() {
        double spread = this.spreads[0];
        for (int i = 1; i < this.spreads.length; ++i) {
            if (this.spreads[i] == spread) continue;
            throw new UnsupportedOperationException("The method getSpread() is only supported for swap legs with constant spreads.");
        }
        return spread;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    public String toString() {
        return "SwapLeg [legSchedule=" + this.legSchedule + ", forwardCurveName=" + this.forwardCurveName + ", notionals=" + Arrays.toString(this.notionals) + ", spreads=" + Arrays.toString(this.spreads) + ", discountCurveName=" + this.discountCurveName + ", discountCurveForNotionalResetName=" + this.discountCurveForNotionalResetName + ", isNotionalExchanged=" + this.isNotionalExchanged + "]";
    }

    @Override
    public InterestRateSwapLegProductDescriptor getDescriptor() {
        return new InterestRateSwapLegProductDescriptor(this.forwardCurveName, this.discountCurveName, new ScheduleDescriptor(this.legSchedule), this.notionals, this.spreads, this.isNotionalExchanged);
    }
}

