/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.calibration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata2.calibration.ParameterObject;
import net.finmath.marketdata2.model.curves.Curve;
import net.finmath.stochastic.RandomVariable;

public class ParameterAggregation<E extends ParameterObject>
implements ParameterObject {
    private final Set<ParameterObject> parameters;

    public ParameterAggregation() {
        this.parameters = new LinkedHashSet<ParameterObject>();
    }

    public ParameterAggregation(Set<E> parameters) {
        this.parameters = new LinkedHashSet<ParameterObject>(parameters);
    }

    public ParameterAggregation(E[] parameters) {
        this.parameters = new LinkedHashSet<ParameterObject>(Arrays.asList(parameters));
    }

    public void add(E parameterObject) {
        this.parameters.add((ParameterObject)parameterObject);
    }

    public void remove(E parameterObject) {
        this.parameters.remove(parameterObject);
    }

    @Override
    public RandomVariable[] getParameter() {
        int parameterArraySize = 0;
        for (ParameterObject parameterVector : this.parameters) {
            if (parameterVector.getParameter() == null) continue;
            parameterArraySize += parameterVector.getParameter().length;
        }
        RandomVariable[] parameterArray = new RandomVariable[parameterArraySize];
        int parameterIndex = 0;
        for (ParameterObject parameterVector : this.parameters) {
            RandomVariable[] parameterVectorOfDouble = parameterVector.getParameter();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameterVectorOfDouble, 0, parameterArray, parameterIndex, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
        }
        return parameterArray;
    }

    @Override
    public void setParameter(RandomVariable[] parameter) {
        int parameterIndex = 0;
        for (ParameterObject parametrizedObject : this.parameters) {
            RandomVariable[] parameterVectorOfDouble = parametrizedObject.getParameter();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameter, parameterIndex, parameterVectorOfDouble, 0, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
            parametrizedObject.setParameter(parameterVectorOfDouble);
        }
    }

    public Map<E, RandomVariable[]> getObjectsToModifyForParameter(RandomVariable[] parameter) {
        HashMap<ParameterObject, RandomVariable[]> result = new HashMap<ParameterObject, RandomVariable[]>();
        int parameterIndex = 0;
        for (ParameterObject parametrizedObject : this.parameters) {
            RandomVariable[] parameterVectorOfDouble = (RandomVariable[])parametrizedObject.getParameter().clone();
            if (parameterVectorOfDouble == null) continue;
            System.arraycopy(parameter, parameterIndex, parameterVectorOfDouble, 0, parameterVectorOfDouble.length);
            parameterIndex += parameterVectorOfDouble.length;
            result.put(parametrizedObject, parameterVectorOfDouble);
        }
        return result;
    }

    @Override
    public Curve getCloneForParameter(RandomVariable[] value) throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Method getCloneForParameter not supported on an aggregate.");
    }
}

