/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.finmath.marketdata2.calibration.ParameterObject;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.Curve;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.model.volatilities.VolatilitySurface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.stochastic.RandomVariable;

public class AnalyticModelFromCurvesAndVols
implements AnalyticModel,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1551367852009541732L;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final Map<String, Curve> curvesMap = new HashMap<String, Curve>();
    private final Map<String, VolatilitySurface> volatilitySurfaceMap = new HashMap<String, VolatilitySurface>();

    public AnalyticModelFromCurvesAndVols() {
        this.abstractRandomVariableFactory = new RandomVariableFromArrayFactory();
    }

    public AnalyticModelFromCurvesAndVols(RandomVariableFactory abstractRandomVariableFactory) {
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
    }

    public AnalyticModelFromCurvesAndVols(Curve[] curves) {
        this();
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
    }

    public AnalyticModelFromCurvesAndVols(RandomVariableFactory abstractRandomVariableFactory, Curve[] curves) {
        this(abstractRandomVariableFactory);
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
    }

    public AnalyticModelFromCurvesAndVols(Collection<Curve> curves) {
        this();
        for (Curve curve : curves) {
            this.curvesMap.put(curve.getName(), curve);
        }
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.abstractRandomVariableFactory.createRandomVariable(value);
    }

    @Override
    public Curve getCurve(String name) {
        return this.curvesMap.get(name);
    }

    @Override
    public Map<String, Curve> getCurves() {
        return Collections.unmodifiableMap(this.curvesMap);
    }

    @Override
    public AnalyticModel addCurve(String name, Curve curve) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.put(name, curve);
        return newModel;
    }

    public AnalyticModel addCurve(Curve curve) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.curvesMap.put(curve.getName(), curve);
        return newModel;
    }

    @Override
    public AnalyticModel addCurves(Curve ... curves) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (Curve curve : curves) {
            newModel.curvesMap.put(curve.getName(), curve);
        }
        return newModel;
    }

    @Override
    public AnalyticModel addCurves(Set<Curve> curves) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (Curve curve : curves) {
            newModel.curvesMap.put(curve.getName(), curve);
        }
        return newModel;
    }

    @Override
    @Deprecated
    public void setCurve(Curve curve) {
        this.curvesMap.put(curve.getName(), curve);
    }

    @Deprecated
    public void setCurves(Curve[] curves) {
        for (Curve curve : curves) {
            this.setCurve(curve);
        }
    }

    @Override
    public DiscountCurveInterface getDiscountCurve(String discountCurveName) {
        DiscountCurveInterface discountCurve = null;
        Curve curve = this.getCurve(discountCurveName);
        if (DiscountCurveInterface.class.isInstance(curve)) {
            discountCurve = (DiscountCurveInterface)curve;
        }
        return discountCurve;
    }

    @Override
    public ForwardCurveInterface getForwardCurve(String forwardCurveName) {
        ForwardCurveInterface forwardCurve = null;
        Curve curve = this.getCurve(forwardCurveName);
        if (ForwardCurveInterface.class.isInstance(curve)) {
            forwardCurve = (ForwardCurveInterface)curve;
        }
        return forwardCurve;
    }

    @Override
    public VolatilitySurface getVolatilitySurface(String name) {
        return this.volatilitySurfaceMap.get(name);
    }

    @Override
    public Map<String, VolatilitySurface> getVolatilitySurfaces() {
        return Collections.unmodifiableMap(this.volatilitySurfaceMap);
    }

    public AnalyticModel addVolatilitySurface(VolatilitySurface volatilitySurface) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        return newModel;
    }

    @Override
    public AnalyticModel addVolatilitySurfaces(VolatilitySurface ... volatilitySurfaces) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (VolatilitySurface volatilitySurface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        }
        return newModel;
    }

    @Override
    public AnalyticModel addVolatilitySurfaces(Set<VolatilitySurface> volatilitySurfaces) {
        AnalyticModelFromCurvesAndVols newModel = this.clone();
        for (VolatilitySurface volatilitySurface : volatilitySurfaces) {
            newModel.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
        }
        return newModel;
    }

    private void setVolatilitySurface(VolatilitySurface volatilitySurface) {
        this.volatilitySurfaceMap.put(volatilitySurface.getName(), volatilitySurface);
    }

    private void set(Object marketDataObject) {
        if (marketDataObject instanceof Curve) {
            this.setCurve((Curve)marketDataObject);
        } else if (marketDataObject instanceof VolatilitySurface) {
            this.setVolatilitySurface((VolatilitySurface)marketDataObject);
        } else {
            throw new IllegalArgumentException("Provided object is not of supported type.");
        }
    }

    @Override
    public AnalyticModelFromCurvesAndVols clone() {
        AnalyticModelFromCurvesAndVols newModel = new AnalyticModelFromCurvesAndVols();
        newModel.curvesMap.putAll(this.curvesMap);
        newModel.volatilitySurfaceMap.putAll(this.volatilitySurfaceMap);
        return newModel;
    }

    @Override
    public AnalyticModel getCloneForParameter(Map<ParameterObject, RandomVariable[]> curveParameterPairs) throws CloneNotSupportedException {
        AnalyticModelFromCurvesAndVols modelClone = this.clone();
        if (curveParameterPairs != null) {
            for (Map.Entry<ParameterObject, RandomVariable[]> curveParameterPair : curveParameterPairs.entrySet()) {
                ParameterObject newCurve = curveParameterPair.getKey().getCloneForParameter(curveParameterPair.getValue());
                modelClone.set(newCurve);
            }
        }
        return modelClone;
    }

    public String toString() {
        return "AnalyticModelFromCuvesAndVols: curves=" + this.curvesMap.keySet();
    }
}

