/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.curves;

import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.CurveInterpolation;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public abstract class AbstractForwardCurve
extends CurveInterpolation
implements ForwardCurveInterface {
    private static final long serialVersionUID = 3735595267579329042L;
    private final String discountCurveName;
    private final Map<Double, Double> paymentOffsets = new ConcurrentHashMap<Double, Double>();
    private final String paymentOffsetCode;
    private final BusinessdayCalendar paymentBusinessdayCalendar;
    private final BusinessdayCalendar.DateRollConvention paymentDateRollConvention;
    private final double paymentOffset;

    public AbstractForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, String discountCurveName) {
        super(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
        this.paymentOffsetCode = paymentOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.paymentDateRollConvention = paymentDateRollConvention;
        this.paymentOffset = Double.NaN;
        this.discountCurveName = discountCurveName;
    }

    public AbstractForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, discountCurveName);
    }

    public AbstractForwardCurve(String name, LocalDate referenceDate, double paymentOffset, String discountCurveName) {
        super(name, referenceDate, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE);
        this.paymentOffset = paymentOffset;
        this.discountCurveName = discountCurveName;
        this.paymentOffsetCode = null;
        this.paymentBusinessdayCalendar = null;
        this.paymentDateRollConvention = null;
    }

    @Override
    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    @Override
    public double getPaymentOffset(double fixingTime) {
        if (this.getPaymentOffsetCode() == null) {
            return this.paymentOffset;
        }
        if (this.paymentOffsets.containsKey(fixingTime)) {
            return this.paymentOffsets.get(fixingTime);
        }
        LocalDate referenceDate = this.getReferenceDate();
        LocalDate fixingDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, fixingTime);
        LocalDate paymentDate = this.getPaymentBusinessdayCalendar().getAdjustedDate(fixingDate, this.getPaymentOffsetCode(), this.getPaymentDateRollConvention());
        double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, paymentDate);
        this.paymentOffsets.put(fixingTime, paymentTime - fixingTime);
        return paymentTime - fixingTime;
    }

    public RandomVariable[] getForwards(AnalyticModel model, double[] fixingTimes) {
        RandomVariable[] values = new RandomVariable[fixingTimes.length];
        for (int i = 0; i < fixingTimes.length; ++i) {
            values[i] = this.getForward(model, fixingTimes[i]);
        }
        return values;
    }

    @Override
    public String toString() {
        return "AbstractForwardCurve [" + super.toString() + ", discountCurveName=" + this.getDiscountCurveName() + ", paymentOffsetCode=" + this.getPaymentOffsetCode() + ", paymentBusinessdayCalendar=" + this.getPaymentBusinessdayCalendar() + ", paymentDateRollConvention=" + (Object)((Object)this.getPaymentDateRollConvention()) + "]";
    }

    public String getPaymentOffsetCode() {
        return this.paymentOffsetCode;
    }

    public BusinessdayCalendar getPaymentBusinessdayCalendar() {
        return this.paymentBusinessdayCalendar;
    }

    protected BusinessdayCalendar.DateRollConvention getPaymentDateRollConvention() {
        return this.paymentDateRollConvention;
    }
}

