/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.curves;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.marketdata2.interpolation.RationalFunctionInterpolation;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.AbstractCurve;
import net.finmath.marketdata2.model.curves.Curve;
import net.finmath.marketdata2.model.curves.CurveBuilder;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.FloatingpointDate;

public class CurveInterpolation
extends AbstractCurve
implements Serializable,
Cloneable {
    private ArrayList<Point> points = new ArrayList();
    private ArrayList<Point> pointsBeingParameters = new ArrayList();
    private InterpolationMethod interpolationMethod = InterpolationMethod.LINEAR;
    private ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.CONSTANT;
    private InterpolationEntity interpolationEntity = InterpolationEntity.LOG_OF_VALUE;
    private RationalFunctionInterpolation rationalFunctionInterpolation = null;
    private transient Object rationalFunctionInterpolationLazyInitLock = new Object();
    private SoftReference<Map<Double, RandomVariable>> curveCacheReference = null;
    private static final long serialVersionUID = -4126228588123963885L;
    private static NumberFormat formatterReal = NumberFormat.getInstance(Locale.US);

    public CurveInterpolation(String name, LocalDate referenceDate, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity, double[] times, RandomVariable[] values) {
        super(name, referenceDate);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
        if (times.length != values.length) {
            throw new IllegalArgumentException("Length of times not equal to length of values.");
        }
        for (int i = 0; i < times.length; ++i) {
            this.addPoint(times[i], values[i], false);
        }
    }

    protected CurveInterpolation(String name, LocalDate referenceDate, InterpolationMethod interpolationMethod, ExtrapolationMethod extrapolationMethod, InterpolationEntity interpolationEntity) {
        super(name, referenceDate);
        this.interpolationMethod = interpolationMethod;
        this.extrapolationMethod = extrapolationMethod;
        this.interpolationEntity = interpolationEntity;
    }

    private CurveInterpolation(String name, LocalDate referenceDate) {
        super(name, referenceDate);
    }

    @Override
    public RandomVariable getValue(double time) {
        return this.getValue(null, time);
    }

    @Override
    public RandomVariable getValue(AnalyticModel model, double time) {
        RandomVariable valueFromCache;
        Map<Double, RandomVariable> curveCache;
        Map<Double, RandomVariable> map = curveCache = this.curveCacheReference != null ? this.curveCacheReference.get() : null;
        if (curveCache == null) {
            curveCache = new ConcurrentHashMap<Double, RandomVariable>();
            this.curveCacheReference = new SoftReference<Map<Double, RandomVariable>>(curveCache);
        }
        if ((valueFromCache = curveCache.get(time)) != null) {
            return valueFromCache;
        }
        RandomVariable value = this.valueFromInterpolationEntity(this.getInterpolationEntityValue(time), time);
        curveCache.put(time, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomVariable getInterpolationEntityValue(double time) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.rationalFunctionInterpolation == null) {
                double[] pointsArray = new double[this.points.size()];
                RandomVariable[] valuesArray = new RandomVariable[this.points.size()];
                for (int i = 0; i < this.points.size(); ++i) {
                    pointsArray[i] = this.points.get(i).time;
                    valuesArray[i] = this.points.get(i).value;
                }
                this.rationalFunctionInterpolation = new RationalFunctionInterpolation(pointsArray, valuesArray, RationalFunctionInterpolation.InterpolationMethod.valueOf(this.interpolationMethod.toString()), RationalFunctionInterpolation.ExtrapolationMethod.valueOf(this.extrapolationMethod.toString()));
            }
        }
        return this.rationalFunctionInterpolation.getValue(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPoint(double time, RandomVariable value, boolean isParameter) {
        Object object = this.rationalFunctionInterpolationLazyInitLock;
        synchronized (object) {
            if (this.interpolationEntity == InterpolationEntity.LOG_OF_VALUE_PER_TIME && time == 0.0) {
                boolean containsOne = false;
                int index = 0;
                for (int i = 0; i < value.size(); ++i) {
                    if (value.get(i) != 1.0) continue;
                    containsOne = true;
                    index = i;
                    break;
                }
                if (containsOne && !isParameter) {
                    return;
                }
                throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0 other than 1.0 (received 1 at index" + index + ").");
            }
            RandomVariable interpolationEntityValue = this.interpolationEntityFromValue(value, time);
            int index = this.getTimeIndex(time);
            if (index >= 0) {
                if (this.points.get(index).value == interpolationEntityValue) {
                    return;
                }
                if (isParameter) {
                    return;
                }
                throw new RuntimeException("Trying to add a value for a time for which another value already exists.");
            }
            Point point = new Point(time, interpolationEntityValue, isParameter);
            this.points.add(-index - 1, point);
            if (isParameter) {
                int parameterIndex = this.getParameterIndex(time);
                if (parameterIndex >= 0) {
                    new RuntimeException("CurveFromInterpolationPoints inconsistent.");
                }
                this.pointsBeingParameters.add(-parameterIndex - 1, point);
            }
            this.rationalFunctionInterpolation = null;
            this.curveCacheReference = null;
        }
    }

    public InterpolationMethod getInterpolationMethod() {
        return this.interpolationMethod;
    }

    public ExtrapolationMethod getExtrapolationMethod() {
        return this.extrapolationMethod;
    }

    public InterpolationEntity getInterpolationEntity() {
        return this.interpolationEntity;
    }

    protected int getTimeIndex(double time) {
        Point point = new Point(time, new RandomVariableFromDoubleArray(Double.NaN), false);
        int index = Collections.binarySearch(this.points, point);
        return index;
    }

    protected int getParameterIndex(double time) {
        Point point = new Point(time, new RandomVariableFromDoubleArray(Double.NaN), false);
        return Collections.binarySearch(this.pointsBeingParameters, point);
    }

    @Override
    public RandomVariable[] getParameter() {
        RandomVariable[] parameters = new RandomVariable[this.pointsBeingParameters.size()];
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            parameters[i] = this.valueFromInterpolationEntity(this.pointsBeingParameters.get(i).value, this.pointsBeingParameters.get(i).time);
        }
        return parameters;
    }

    @Override
    public void setParameter(RandomVariable[] parameter) {
        throw new UnsupportedOperationException("This class is immutable. Use getCloneForParameter(double[]) instead.");
    }

    private void setParameterPrivate(RandomVariable[] parameter) {
        for (int i = 0; i < this.pointsBeingParameters.size(); ++i) {
            this.pointsBeingParameters.get(i).value = this.interpolationEntityFromValue(parameter[i], this.pointsBeingParameters.get(i).time);
        }
        this.rationalFunctionInterpolation = null;
        this.curveCacheReference = null;
    }

    private RandomVariable interpolationEntityFromValue(RandomVariable value, double time) {
        switch (this.interpolationEntity) {
            default: {
                return value;
            }
            case LOG_OF_VALUE: {
                return value.floor(0.0).log();
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        if (time == 0.0) {
            throw new IllegalArgumentException("The interpolation method LOG_OF_VALUE_PER_TIME does not allow to add a value at time = 0.");
        }
        return value.floor(0.0).log().div(time);
    }

    private RandomVariable valueFromInterpolationEntity(RandomVariable interpolationEntityValue, double time) {
        switch (this.interpolationEntity) {
            default: {
                return interpolationEntityValue;
            }
            case LOG_OF_VALUE: {
                return interpolationEntityValue.exp();
            }
            case LOG_OF_VALUE_PER_TIME: 
        }
        return interpolationEntityValue.mult(time).exp();
    }

    @Override
    public CurveInterpolation clone() throws CloneNotSupportedException {
        CurveInterpolation newCurve = (CurveInterpolation)super.clone();
        newCurve.points = new ArrayList();
        newCurve.pointsBeingParameters = new ArrayList();
        newCurve.rationalFunctionInterpolation = null;
        newCurve.curveCacheReference = null;
        for (Point point : this.points) {
            Point newPoint = (Point)point.clone();
            newCurve.points.add(newPoint);
            if (!point.isParameter) continue;
            newCurve.pointsBeingParameters.add(newPoint);
        }
        return newCurve;
    }

    @Override
    public Curve getCloneForParameter(RandomVariable[] parameter) throws CloneNotSupportedException {
        if (Arrays.equals(parameter, this.getParameter())) {
            return this;
        }
        CurveInterpolation newCurve = this.clone();
        newCurve.setParameterPrivate(parameter);
        return newCurve;
    }

    @Override
    public CurveBuilder getCloneBuilder() throws CloneNotSupportedException {
        Builder builder = new Builder(this);
        return builder;
    }

    @Override
    public String toString() {
        StringBuilder curveTableString = new StringBuilder();
        DecimalFormat formatTime = new DecimalFormat("0.00000000E0");
        for (Point point : this.points) {
            curveTableString.append(formatTime.format(point.time) + "\t");
            curveTableString.append(FloatingpointDate.getDateFromFloatingPointDate(this.getReferenceDate(), point.time) + "\t");
            curveTableString.append(this.valueFromInterpolationEntity(point.value, point.time) + "\n");
        }
        return "CurveFromInterpolationPoints [points=" + this.points + ", pointsBeingParameters=" + this.pointsBeingParameters + ", interpolationMethod=" + (Object)((Object)this.interpolationMethod) + ", extrapolationMethod=" + (Object)((Object)this.extrapolationMethod) + ", interpolationEntity=" + (Object)((Object)this.interpolationEntity) + ", rationalFunctionInterpolation=" + this.rationalFunctionInterpolation + ", toString()=" + super.toString() + ",\n" + curveTableString + "]";
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.rationalFunctionInterpolationLazyInitLock = new Object();
    }

    public static class Builder
    implements CurveBuilder {
        private CurveInterpolation curveInterpolation = null;

        public Builder() {
            this.curveInterpolation = new CurveInterpolation(null, null);
        }

        public Builder(String name, LocalDate referenceDate) {
            this.curveInterpolation = new CurveInterpolation(name, referenceDate);
        }

        public Builder(CurveInterpolation curveInterpolation) throws CloneNotSupportedException {
            this.curveInterpolation = curveInterpolation.clone();
        }

        @Override
        public Curve build() {
            CurveInterpolation buildCurve = this.curveInterpolation;
            this.curveInterpolation = null;
            return buildCurve;
        }

        public CurveBuilder setInterpolationMethod(InterpolationMethod interpolationMethod) {
            this.curveInterpolation.interpolationMethod = interpolationMethod;
            return this;
        }

        public CurveBuilder setExtrapolationMethod(ExtrapolationMethod extrapolationMethod) {
            this.curveInterpolation.extrapolationMethod = extrapolationMethod;
            return this;
        }

        public CurveBuilder setInterpolationEntity(InterpolationEntity interpolationEntity) {
            this.curveInterpolation.interpolationEntity = interpolationEntity;
            return this;
        }

        @Override
        public CurveBuilder addPoint(double time, RandomVariable value, boolean isParameter) {
            this.curveInterpolation.addPoint(time, value, isParameter);
            return this;
        }
    }

    private static class Point
    implements Comparable<Point>,
    Serializable {
        private static final long serialVersionUID = 8857387999991917430L;
        private final double time;
        private RandomVariable value;
        private final boolean isParameter;

        Point(double time, RandomVariable value, boolean isParameter) {
            this.time = time;
            this.value = value;
            this.isParameter = isParameter;
        }

        @Override
        public int compareTo(Point point) {
            if (this.time < point.time) {
                return -1;
            }
            if (this.time > point.time) {
                return 1;
            }
            return 0;
        }

        public Object clone() {
            return new Point(this.time, this.value, this.isParameter);
        }
    }

    public static enum InterpolationEntity {
        VALUE,
        LOG_OF_VALUE,
        LOG_OF_VALUE_PER_TIME;

    }

    public static enum ExtrapolationMethod {
        DEFAULT,
        CONSTANT,
        LINEAR;

    }

    public static enum InterpolationMethod {
        PIECEWISE_CONSTANT,
        PIECEWISE_CONSTANT_LEFTPOINT,
        PIECEWISE_CONSTANT_RIGHTPOINT,
        LINEAR,
        HARMONIC_SPLINE,
        HARMONIC_SPLINE_WITH_MONOTONIC_FILTERING;

    }
}

