/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.function.DoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.CurveInterpolation;
import net.finmath.marketdata2.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterpolation;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class DiscountCurveInterpolation
extends CurveInterpolation
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = -4126228588123963885L;

    private DiscountCurveInterpolation(String name) {
        super(name, null, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.LOG_OF_VALUE_PER_TIME);
    }

    private DiscountCurveInterpolation(String name, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        super(name, null, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    private DiscountCurveInterpolation(String name, LocalDate referenceDate, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        super(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, LocalDate referenceDate, double[] times, RandomVariable[] givenDiscountFactors, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], isParameter != null && isParameter[timeIndex]);
        }
        return discountFactors;
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, RandomVariable[] givenDiscountFactors, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, null, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, RandomVariable[] givenDiscountFactors, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        boolean[] isParameter = new boolean[times.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            isParameter[timeIndex] = times[timeIndex] > 0.0;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        RandomVariable[] givenDiscountFactorsAsRandomVariables = (RandomVariable[])DoubleStream.of(givenDiscountFactors).mapToObj(new DoubleFunction<RandomVariableFromDoubleArray>(){

            @Override
            public RandomVariableFromDoubleArray apply(double x) {
                return new RandomVariableFromDoubleArray(x);
            }
        }).toArray(RandomVariable[]::new);
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactorsAsRandomVariables, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, RandomVariable[] givenDiscountFactors) {
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            discountFactors.addDiscountFactor(times[timeIndex], givenDiscountFactors[timeIndex], times[timeIndex] > 0.0);
        }
        return discountFactors;
    }

    public static DiscountCurveInterpolation createDiscountCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors) {
        RandomVariable[] givenDiscountFactorsAsRandomVariables = (RandomVariable[])DoubleStream.of(givenDiscountFactors).mapToObj(new DoubleFunction<RandomVariableFromDoubleArray>(){

            @Override
            public RandomVariableFromDoubleArray apply(double x) {
                return new RandomVariableFromDoubleArray(x);
            }
        }).toArray(RandomVariable[]::new);
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactorsAsRandomVariables);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, RandomVariable[] givenZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        RandomVariable[] givenDiscountFactors = new RandomVariable[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = givenZeroRates[timeIndex].mult(-times[timeIndex]).exp();
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, Date referenceDate, double[] times, RandomVariable[] givenZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        return DiscountCurveInterpolation.createDiscountCurveFromZeroRates(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), times, givenZeroRates, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, LocalDate referenceDate, double[] times, RandomVariable[] givenZeroRates, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        RandomVariable[] givenDiscountFactors = new RandomVariable[givenZeroRates.length];
        boolean[] isParameter = new boolean[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = givenZeroRates[timeIndex].mult(-times[timeIndex]).exp();
            isParameter[timeIndex] = false;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromZeroRates(String name, double[] times, RandomVariable[] givenZeroRates) {
        RandomVariable[] givenDiscountFactors = new RandomVariable[givenZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = givenZeroRates[timeIndex].mult(-times[timeIndex]).exp();
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, times, givenDiscountFactors);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, RandomVariable[] givenAnnualizedZeroRates, boolean[] isParameter, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        RandomVariable[] givenDiscountFactors = new RandomVariable[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = givenAnnualizedZeroRates[timeIndex].add(1.0).pow(-times[timeIndex]);
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterpolation createDiscountCurveFromAnnualizedZeroRates(String name, LocalDate referenceDate, double[] times, RandomVariable[] givenAnnualizedZeroRates, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity) {
        RandomVariable[] givenDiscountFactors = new RandomVariable[givenAnnualizedZeroRates.length];
        boolean[] isParameter = new boolean[givenAnnualizedZeroRates.length];
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            givenDiscountFactors[timeIndex] = givenAnnualizedZeroRates[timeIndex].add(1.0).pow(-times[timeIndex]);
            isParameter[timeIndex] = false;
        }
        return DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(name, referenceDate, times, givenDiscountFactors, isParameter, interpolationMethod, extrapolationMethod, interpolationEntity);
    }

    public static DiscountCurveInterface createDiscountFactorsFromForwardRates(String name, TimeDiscretization tenor, RandomVariable[] forwardRates) {
        DiscountCurveInterpolation discountFactors = new DiscountCurveInterpolation(name);
        RandomVariable df = forwardRates[0].mult(tenor.getTimeStep(0)).add(1.0).invert();
        discountFactors.addDiscountFactor(tenor.getTime(1), df, tenor.getTime(1) > 0.0);
        for (int timeIndex = 1; timeIndex < tenor.getNumberOfTimeSteps(); ++timeIndex) {
            df = df.div(forwardRates[timeIndex].mult(tenor.getTimeStep(timeIndex)).add(1.0));
            discountFactors.addDiscountFactor(tenor.getTime(timeIndex + 1), df, tenor.getTime(timeIndex + 1) > 0.0);
        }
        return discountFactors;
    }

    public static DiscountCurveInterface createDiscountCurveFromMonteCarloLiborModel(String forwardCurveName, LIBORModelMonteCarloSimulationModel model, double startTime) throws CalculationException {
        if (model.getModel().getDiscountCurve() == null || model.getModel().getDiscountCurve().getName().toLowerCase().contains("DiscountCurveFromForwardCurve".toLowerCase())) {
            return new DiscountCurveFromForwardCurve(ForwardCurveInterpolation.createForwardCurveFromMonteCarloLiborModel(forwardCurveName, model, startTime));
        }
        return (DiscountCurveInterface)((Object)model.getModel().getDiscountCurve());
    }

    public static RandomVariable[] createZeroRates(double time, double[] maturities, LIBORModelMonteCarloSimulationModel model) throws CalculationException {
        double[] liborTimes;
        int indexOffset;
        RandomVariable[] forwardRates;
        double periodEnd;
        double periodStart;
        int firstLiborIndex = model.getLiborPeriodDiscretization().getTimeIndexNearestGreaterOrEqual(time);
        int remainingLibors = model.getNumberOfLibors() - firstLiborIndex;
        if (model.getLiborPeriodDiscretization().getTime(firstLiborIndex) > time) {
            periodStart = time;
            periodEnd = model.getLiborPeriodDiscretization().getTime(firstLiborIndex);
            forwardRates = new RandomVariable[remainingLibors + 1];
            forwardRates[0] = model.getLIBOR(time, periodStart, periodEnd);
            indexOffset = 1;
            liborTimes = new double[forwardRates.length + 1];
            liborTimes[0] = 0.0;
        } else {
            forwardRates = new RandomVariable[remainingLibors];
            indexOffset = 0;
            liborTimes = new double[forwardRates.length + 1];
        }
        for (int liborIndex = firstLiborIndex; liborIndex < model.getNumberOfLibors(); ++liborIndex) {
            periodStart = model.getLiborPeriodDiscretization().getTime(liborIndex);
            periodEnd = model.getLiborPeriodDiscretization().getTime(liborIndex + 1);
            forwardRates[liborIndex - firstLiborIndex + indexOffset] = model.getLIBOR(time, periodStart, periodEnd);
        }
        for (int i = indexOffset; i < liborTimes.length; ++i) {
            liborTimes[i] = model.getLiborPeriod(firstLiborIndex + i - indexOffset) - time;
        }
        DiscountCurveInterpolation df = (DiscountCurveInterpolation)DiscountCurveInterpolation.createDiscountFactorsFromForwardRates("", new TimeDiscretizationFromArray(liborTimes), forwardRates);
        return df.getZeroRates(maturities);
    }

    public RandomVariable getZeroRate(double maturity) {
        if (maturity == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return this.getDiscountFactor(maturity).log().div(-maturity);
    }

    public RandomVariable[] getZeroRates(double[] maturities) {
        RandomVariable[] values = new RandomVariable[maturities.length];
        for (int i = 0; i < maturities.length; ++i) {
            values[i] = this.getZeroRate(maturities[i]);
        }
        return values;
    }

    protected void addDiscountFactor(double maturity, RandomVariable discountFactor, boolean isParameter) {
        this.addPoint(maturity, discountFactor, isParameter);
    }

    @Override
    public String toString() {
        return "DiscountCurveInterpolation [" + super.toString() + "]";
    }

    @Override
    public RandomVariable getDiscountFactor(double maturity) {
        return this.getValue(null, maturity);
    }

    @Override
    public RandomVariable getDiscountFactor(AnalyticModel model, double maturity) {
        return this.getValue(model, maturity);
    }
}

