/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.DoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.exception.CalculationException;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.AbstractForwardCurve;
import net.finmath.marketdata2.model.curves.CurveInterpolation;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;

public class ForwardCurveInterpolation
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private InterpolationEntityForward interpolationEntityForward = InterpolationEntityForward.FORWARD;

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
        if (interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            super.addPoint(0.0, new RandomVariableFromDoubleArray(1.0), false);
        }
    }

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, interpolationEntityForward, discountCurveName);
    }

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.FORWARD, discountCurveName);
    }

    public ForwardCurveInterpolation(String name, double paymentOffset, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, null, paymentOffset, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, RandomVariable[] givenForwards) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurveInterpolation.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, Date referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, RandomVariable[] givenForwards) {
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, String interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, RandomVariable[] givenForwards) {
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.valueOf(interpolationEntityForward), discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, RandomVariable[] givenForwards) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, referenceDate, paymentOffsetCode, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurveInterpolation.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, double[] times, RandomVariable[] givenForwards, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(null, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromDiscountFactors(String name, double[] times, RandomVariable[] givenDiscountFactors, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        if (times.length == 0) {
            throw new IllegalArgumentException("Vector of times must not be empty.");
        }
        if (times[0] > 0.0) {
            RandomVariable forward = givenDiscountFactors[0].sub(1.0).pow(-1.0).div(times[0]);
            forwardCurveInterpolation.addForward(null, 0.0, forward, true);
        }
        for (int timeIndex = 0; timeIndex < times.length - 1; ++timeIndex) {
            RandomVariable forward = givenDiscountFactors[timeIndex].div(givenDiscountFactors[timeIndex + 1].sub(1.0)).div(times[timeIndex + 1] - times[timeIndex]);
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(null, fixingTime, forward, isParameter);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, double[] times, RandomVariable[] givenForwards, AnalyticModel model, String discountCurveName, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(model, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, double[] times, double[] givenForwards, AnalyticModel model, String discountCurveName, double paymentOffset) {
        RandomVariable[] givenForwardsAsRandomVariables = (RandomVariable[])DoubleStream.of(givenForwards).mapToObj(new DoubleFunction<RandomVariableFromDoubleArray>(){

            @Override
            public RandomVariableFromDoubleArray apply(double x) {
                return new RandomVariableFromDoubleArray(x);
            }
        }).toArray(RandomVariable[]::new);
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, times, givenForwardsAsRandomVariables, model, discountCurveName, paymentOffset);
    }

    public static ForwardCurveInterpolation createForwardCurveFromMonteCarloLiborModel(String name, LIBORModelMonteCarloSimulationModel model, double startTime) throws CalculationException {
        int timeIndex = model.getTimeIndex(startTime);
        ArrayList<RandomVariable> liborsAtTimeIndex = new ArrayList<RandomVariable>();
        int firstLiborIndex = model.getLiborPeriodDiscretization().getTimeIndexNearestGreaterOrEqual(startTime);
        double firstLiborTime = model.getLiborPeriodDiscretization().getTime(firstLiborIndex);
        if (firstLiborTime > startTime) {
            liborsAtTimeIndex.add(model.getLIBOR(startTime, startTime, firstLiborTime));
        }
        double[] times = new double[firstLiborTime == startTime ? model.getNumberOfLibors() - firstLiborIndex : model.getNumberOfLibors() - firstLiborIndex + 1];
        times[0] = 0.0;
        int indexOffset = firstLiborTime == startTime ? 0 : 1;
        for (int i = firstLiborIndex; i < model.getNumberOfLibors(); ++i) {
            liborsAtTimeIndex.add(model.getLIBOR(timeIndex, i));
            times[i - firstLiborIndex + indexOffset] = model.getLiborPeriodDiscretization().getTime(i) - startTime;
        }
        RandomVariable[] libors = liborsAtTimeIndex.toArray(new RandomVariable[liborsAtTimeIndex.size()]);
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, times, libors, model.getLiborPeriodDiscretization().getTimeStep(firstLiborIndex));
    }

    @Override
    public RandomVariable getForward(AnalyticModel model, double fixingTime) {
        double paymentOffset = this.getPaymentOffset(fixingTime);
        RandomVariable interpolationEntityForwardValue = this.getValue(model, fixingTime);
        switch (this.interpolationEntityForward) {
            default: {
                return interpolationEntityForwardValue;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                if (model == null) {
                    throw new IllegalArgumentException("model==null. Not allowed for interpolationEntityForward " + (Object)((Object)this.interpolationEntityForward));
                }
                return interpolationEntityForwardValue.div(model.getDiscountCurve(this.getDiscountCurveName()).getValue(model, fixingTime + paymentOffset));
            }
            case ZERO: {
                RandomVariable interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
                return interpolationEntityForwardValue2.mult(fixingTime + paymentOffset).sub(interpolationEntityForwardValue.mult(fixingTime)).exp().sub(1.0).div(paymentOffset);
            }
            case DISCOUNTFACTOR: 
        }
        RandomVariable interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
        return interpolationEntityForwardValue.div(interpolationEntityForwardValue2).sub(1.0).div(paymentOffset);
    }

    @Override
    public RandomVariable getForward(AnalyticModel model, double fixingTime, double paymentOffset) {
        return this.getForward(model, fixingTime);
    }

    private void addForward(AnalyticModel model, double fixingTime, RandomVariable forward, boolean isParameter) {
        RandomVariable interpolationEntityForwardValue;
        double interpolationEntitiyTime;
        switch (this.interpolationEntityForward) {
            default: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward;
                break;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward.mult(model.getDiscountCurve(this.getDiscountCurveName()).getValue(model, fixingTime + this.getPaymentOffset(fixingTime)));
                break;
            }
            case ZERO: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = forward.mult(paymentOffset).add(1.0).log().div(paymentOffset);
                break;
            }
            case DISCOUNTFACTOR: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = this.getValue(fixingTime).div(forward.mult(paymentOffset).add(1.0));
                break;
            }
        }
        super.addPoint(interpolationEntitiyTime, interpolationEntityForwardValue, isParameter);
    }

    @Override
    protected void addPoint(double time, RandomVariable value, boolean isParameter) {
        if (this.interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            time += this.getPaymentOffset(time);
        }
        super.addPoint(time, value, isParameter);
    }

    public InterpolationEntityForward getInterpolationEntityForward() {
        return this.interpolationEntityForward;
    }

    @Override
    public String toString() {
        return "ForwardCurve [" + super.toString() + ", interpolationEntityForward=" + (Object)((Object)this.interpolationEntityForward) + "]";
    }

    public static enum InterpolationEntityForward {
        FORWARD,
        FORWARD_TIMES_DISCOUNTFACTOR,
        ZERO,
        DISCOUNTFACTOR;

    }
}

