/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;

public class Cashflow
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final double flowAmount;
    private final double flowDate;
    private final boolean isPayer;
    private final String discountCurveName;

    public Cashflow(String currency, double flowAmount, double flowDate, boolean isPayer, String discountCurveName) {
        this.flowAmount = flowAmount;
        this.flowDate = flowDate;
        this.isPayer = isPayer;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        RandomVariable discountFactor = this.flowDate > evaluationTime ? discountCurve.getDiscountFactor(model, this.flowDate) : model.getRandomVariableForConstant(0.0);
        RandomVariable value = discountFactor.mult(this.flowAmount * (this.isPayer ? -1.0 : 1.0));
        return value.div(discountCurve.getDiscountFactor(model, evaluationTime));
    }
}

