/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.Schedule;

public class ForwardRateAgreement
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private final boolean isPayer;

    public ForwardRateAgreement(Schedule schedule, double spread, String forwardCurveName, String discountCurveName, boolean isPayer) {
        this.schedule = schedule;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
        this.isPayer = isPayer;
        if (schedule.getNumberOfPeriods() > 1) {
            throw new IllegalArgumentException("Number of periods has to be 1: Change frequency to 'tenor'!");
        }
    }

    public ForwardRateAgreement(Schedule schedule, double spread, String forwardCurveName, String discountCurveName) {
        this(schedule, spread, forwardCurveName, discountCurveName, true);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double fixingDate = this.schedule.getFixing(0);
        double paymentDate = this.schedule.getPayment(0);
        double periodLength = this.schedule.getPeriodLength(0);
        RandomVariable forward = new RandomVariableFromDoubleArray(0.0);
        if (forwardCurve != null) {
            forward = forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
        }
        double notional = this.isPayer ? 1.0 : -1.0;
        RandomVariable discountFactorFixingDate = fixingDate > evaluationTime ? discountCurve.getDiscountFactor(model, fixingDate) : new RandomVariableFromDoubleArray(0.0);
        return forward.sub(this.spread).div(forward.mult(periodLength).add(1.0)).mult(discountFactorFixingDate).mult(periodLength * notional);
    }

    public RandomVariable getRate(AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null) {
            throw new IllegalArgumentException("No forward curve of name '" + this.forwardCurveName + "' found in given model:\n" + model.toString());
        }
        double fixingDate = this.schedule.getFixing(0);
        return forwardCurve.getForward(model, fixingDate);
    }
}

