/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.Schedule;

public class SwapLeg
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule legSchedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private final String discountCurveForNotionalResetName;
    private boolean isNotionalExchanged = false;

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName, String discountCurveForNotionalResetName, boolean isNotionalExchanged) {
        this.legSchedule = legSchedule;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
        this.discountCurveForNotionalResetName = discountCurveForNotionalResetName == "" ? discountCurveName : discountCurveForNotionalResetName;
        this.isNotionalExchanged = isNotionalExchanged;
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName, boolean isNotionalExchanged) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, discountCurveName, isNotionalExchanged);
    }

    public SwapLeg(Schedule legSchedule, String forwardCurveName, double spread, String discountCurveName) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, discountCurveName, false);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveForNotionalReset = model.getDiscountCurve(this.discountCurveForNotionalResetName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        if (discountCurveForNotionalReset == null) {
            throw new IllegalArgumentException("No discountCurveForNotionalReset with name '" + this.discountCurveForNotionalResetName + "' was found in the model:\n" + model.toString());
        }
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        RandomVariable value = model.getRandomVariableForConstant(0.0);
        for (int periodIndex = 0; periodIndex < this.legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = this.legSchedule.getFixing(periodIndex);
            double periodStart = this.legSchedule.getPeriodStart(periodIndex);
            double periodEnd = this.legSchedule.getPeriodEnd(periodIndex);
            double paymentDate = this.legSchedule.getPayment(periodIndex);
            double periodLength = this.legSchedule.getPeriodLength(periodIndex);
            RandomVariable forward = model.getRandomVariableForConstant(this.spread);
            if (forwardCurve != null) {
                forward = forward.add(forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate));
            }
            RandomVariable notional = discountCurveForNotionalReset.getDiscountFactor(model, periodStart).div(discountCurve.getDiscountFactor(model, periodStart));
            RandomVariable discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : model.getRandomVariableForConstant(0.0);
            value = value.add(notional.mult(forward).mult(periodLength).mult(discountFactor));
            if (!this.isNotionalExchanged) continue;
            if (periodEnd > evaluationTime) {
                value = value.add(notional.mult(discountCurve.getDiscountFactor(model, periodEnd)));
            }
            if (!(periodStart > evaluationTime)) continue;
            value = value.sub(notional.mult(discountCurve.getDiscountFactor(model, periodStart)));
        }
        return value.div(discountCurve.getDiscountFactor(model, evaluationTime));
    }

    public Schedule getSchedule() {
        return this.legSchedule;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getSpread() {
        return this.spread;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    public String toString() {
        return "SwapLeg [legSchedule=" + this.legSchedule + ", forwardCurveName=" + this.forwardCurveName + ", spread=" + this.spread + ", discountCurveName=" + this.discountCurveName + ", discountCurveForNotionalResetName=" + this.discountCurveForNotionalResetName + ", isNotionalExchanged=" + this.isNotionalExchanged + "]";
    }
}

