/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.AssetModelDescriptor;

public class BlackScholesModelDescriptor
implements AssetModelDescriptor {
    private final LocalDate referenceDate;
    private final Double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final Double volatility;

    public BlackScholesModelDescriptor(LocalDate referenceDate, Double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, Double volatility) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.volatility = volatility;
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return "Single asset Black Scholes model";
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public Double getVolatility() {
        return this.volatility;
    }
}

