/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.AssetModelDescriptor;

public class HestonModelDescriptor
implements AssetModelDescriptor {
    private final LocalDate referenceDate;
    private final Double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final Double volatility;
    private final Double theta;
    private final Double kappa;
    private final Double xi;
    private final Double rho;

    public HestonModelDescriptor(LocalDate referenceDate, Double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, Double volatility, Double theta, Double kappa, Double xi, Double rho) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.volatility = volatility;
        this.theta = theta;
        this.kappa = kappa;
        this.xi = xi;
        this.rho = rho;
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return "Single asset Heston model";
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public Double getVolatility() {
        return this.volatility;
    }

    public Double getTheta() {
        return this.theta;
    }

    public Double getKappa() {
        return this.kappa;
    }

    public Double getXi() {
        return this.xi;
    }

    public Double getRho() {
        return this.rho;
    }
}

