/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleFromPeriods;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.daycount.DayCountConvention;

public class ScheduleDescriptor {
    private final InternalScheduleDescriptor descriptor;

    public ScheduleDescriptor(List<Period> periods, DayCountConvention daycountConvention) {
        this.descriptor = new ScheduleDescriptorFromPeriods(periods, daycountConvention);
    }

    public ScheduleDescriptor(Schedule schedule) {
        this.descriptor = new ScheduleDescriptorFromPeriods(schedule.getPeriods(), schedule.getDaycountconvention());
    }

    public ScheduleDescriptor(LocalDate startDate, LocalDate maturityDate, ScheduleGenerator.Frequency frequency, ScheduleGenerator.DaycountConvention daycountConvention, ScheduleGenerator.ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays, boolean isUseEndOfMonth) {
        this.descriptor = new ScheduleDescriptorFromGenerator(startDate, maturityDate, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays, isUseEndOfMonth);
    }

    public ScheduleDescriptor(LocalDate startDate, LocalDate maturityDate, ScheduleGenerator.Frequency frequency, ScheduleGenerator.DaycountConvention daycountConvention, ScheduleGenerator.ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, AbstractBusinessdayCalendar abstractBusinessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        this(startDate, maturityDate, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, abstractBusinessdayCalendar, fixingOffsetDays, paymentOffsetDays, false);
    }

    public Schedule getSchedule(LocalDate referenceDate) {
        return this.descriptor.getSchedule(referenceDate);
    }

    public int getNumberOfPeriods() {
        return this.descriptor.getSchedule(LocalDate.of(1970, 1, 1)).getNumberOfPeriods();
    }

    public List<Period> getPeriods() {
        return this.descriptor.getSchedule(LocalDate.of(1970, 1, 1)).getPeriods();
    }

    private static class ScheduleDescriptorFromGenerator
    implements InternalScheduleDescriptor {
        private final LocalDate startDate;
        private final LocalDate maturityDate;
        private final ScheduleGenerator.Frequency frequency;
        private final ScheduleGenerator.DaycountConvention daycountConvention;
        private final ScheduleGenerator.ShortPeriodConvention shortPeriodConvention;
        private final BusinessdayCalendar.DateRollConvention dateRollConvention;
        private final BusinessdayCalendar businessdayCalendar;
        private final int fixingOffsetDays;
        private final int paymentOffsetDays;
        private final boolean isUseEndOfMonth;

        private ScheduleDescriptorFromGenerator(LocalDate startDate, LocalDate maturityDate, ScheduleGenerator.Frequency frequency, ScheduleGenerator.DaycountConvention daycountConvention, ScheduleGenerator.ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays, boolean isUseEndOfMonth) {
            this.startDate = startDate;
            this.maturityDate = maturityDate;
            this.frequency = frequency;
            this.daycountConvention = daycountConvention;
            this.shortPeriodConvention = shortPeriodConvention;
            this.dateRollConvention = dateRollConvention;
            this.businessdayCalendar = businessdayCalendar;
            this.fixingOffsetDays = fixingOffsetDays;
            this.paymentOffsetDays = paymentOffsetDays;
            this.isUseEndOfMonth = isUseEndOfMonth;
        }

        @Override
        public Schedule getSchedule(LocalDate referenceDate) {
            return ScheduleGenerator.createScheduleFromConventions(referenceDate, this.startDate, this.maturityDate, this.frequency, this.daycountConvention, this.shortPeriodConvention, this.dateRollConvention, this.businessdayCalendar, this.fixingOffsetDays, this.paymentOffsetDays, this.isUseEndOfMonth);
        }
    }

    private static class ScheduleDescriptorFromPeriods
    implements InternalScheduleDescriptor {
        private final List<Period> periods;
        private final DayCountConvention daycountConvention;

        private ScheduleDescriptorFromPeriods(List<Period> periods, DayCountConvention daycountConvention) {
            this.periods = periods;
            this.daycountConvention = daycountConvention;
        }

        @Override
        public Schedule getSchedule(LocalDate referenceDate) {
            return new ScheduleFromPeriods(referenceDate, this.periods, this.daycountConvention);
        }

        public List<Period> getPeriods() {
            return Collections.unmodifiableList(this.periods);
        }

        public DayCountConvention getDaycountConvention() {
            return this.daycountConvention;
        }
    }

    private static interface InternalScheduleDescriptor {
        public Schedule getSchedule(LocalDate var1);
    }
}

