/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.finitedifference.models.FDMBlackScholesModel;
import net.finmath.finitedifference.models.FiniteDifference1DModel;
import net.finmath.finitedifference.products.FDMEuropeanCallOption;
import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.Model;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.SingleAssetProductDescriptor;
import net.finmath.modelling.descriptor.BlackScholesModelDescriptor;
import net.finmath.modelling.descriptor.SingleAssetEuropeanOptionProductDescriptor;
import net.finmath.time.FloatingpointDate;

public class BlackScholesModelMonteCarloFiniteDifference1D
implements ModelFactory<BlackScholesModelDescriptor> {
    private final double theta;

    public BlackScholesModelMonteCarloFiniteDifference1D(double theta) {
        this.theta = theta;
    }

    @Override
    public DescribedModel<BlackScholesModelDescriptor> getModelFromDescriptor(final BlackScholesModelDescriptor modelDescriptor) {
        final double initialValue = modelDescriptor.getInitialValue();
        final double riskFreeRate = -Math.log(modelDescriptor.getDiscountCurveForForwardRate().getDiscountFactor(1.0));
        final double volatility = modelDescriptor.getVolatility();
        int numTimesteps = 35;
        int numSpacesteps = 120;
        int numStandardDeviations = 5;
        final double center = initialValue;
        class BlackScholesFDModel
        extends FDMBlackScholesModel
        implements DescribedModel<BlackScholesModelDescriptor> {
            BlackScholesFDModel() {
                super(35, 120, 5, d, BlackScholesModelMonteCarloFiniteDifference1D.this.theta, d2, d3, d4);
            }

            @Override
            public BlackScholesModelDescriptor getDescriptor() {
                return modelDescriptor;
            }

            @Override
            public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(final ProductDescriptor productDescriptor) {
                if (productDescriptor instanceof SingleAssetEuropeanOptionProductDescriptor) {
                    class FDCallOptionProduct
                    extends FDMEuropeanCallOption
                    implements DescribedProduct<SingleAssetProductDescriptor> {
                        FDCallOptionProduct() {
                            super(FloatingpointDate.getFloatingPointDateFromDate(modelDescriptor.getReferenceDate(), ((SingleAssetEuropeanOptionProductDescriptor)productDescriptor2).getMaturity()), ((SingleAssetEuropeanOptionProductDescriptor)productDescriptor2).getStrike());
                        }

                        @Override
                        public Object getValue(double evaluationTime, Model model) {
                            return this.getValues(evaluationTime, model);
                        }

                        @Override
                        public Map<String, Object> getValues(double evaluationTime, Model model) {
                            double value;
                            double[][] valueFDM = this.getValue(0.0, (FiniteDifference1DModel)model);
                            double[] initialStockPrice = valueFDM[0];
                            double[] optionValue = valueFDM[1];
                            int indexOfSpot = Arrays.binarySearch(initialStockPrice, initialValue);
                            if (indexOfSpot >= 0) {
                                value = optionValue[indexOfSpot];
                            } else {
                                int indexOfSpotLow = -indexOfSpot - 2;
                                double alpha = (initialValue - initialStockPrice[indexOfSpotLow]) / (initialStockPrice[indexOfSpotLow + 1] - initialStockPrice[indexOfSpotLow]);
                                value = (1.0 - alpha) * optionValue[indexOfSpotLow] + alpha * optionValue[indexOfSpotLow + 1];
                            }
                            HashMap<String, Object> results = new HashMap<String, Object>();
                            results.put("value", value);
                            return results;
                        }

                        @Override
                        public SingleAssetProductDescriptor getDescriptor() {
                            return (SingleAssetProductDescriptor)productDescriptor;
                        }
                    }
                    return new FDCallOptionProduct();
                }
                String name = modelDescriptor.name();
                throw new IllegalArgumentException("Unsupported product type " + name);
            }
        }
        return new BlackScholesFDModel();
    }
}

