/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.SingleAssetProductDescriptor;
import net.finmath.modelling.descriptor.HestonModelDescriptor;
import net.finmath.modelling.productfactory.SingleAssetMonteCarloProductFactory;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.HestonModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;

public class HestonModelMonteCarloFactory
implements ModelFactory<HestonModelDescriptor> {
    private final HestonModel.Scheme scheme;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private final IndependentIncrements brownianMotion;

    public HestonModelMonteCarloFactory(HestonModel.Scheme scheme, RandomVariableFactory abstractRandomVariableFactory, IndependentIncrements brownianMotion) {
        this.scheme = scheme;
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.brownianMotion = brownianMotion;
    }

    @Override
    public DescribedModel<HestonModelDescriptor> getModelFromDescriptor(final HestonModelDescriptor modelDescriptor) {
        HestonModel model = new HestonModel(modelDescriptor, this.scheme, this.abstractRandomVariableFactory);
        class HestonMonteCarloModel
        extends MonteCarloAssetModel
        implements DescribedModel<HestonModelDescriptor> {
            private final SingleAssetMonteCarloProductFactory productFactory;

            HestonMonteCarloModel(ProcessModel model, MonteCarloProcess process) {
                super(model, process);
                this.productFactory = new SingleAssetMonteCarloProductFactory(modelDescriptor.getReferenceDate());
            }

            @Override
            public HestonModelDescriptor getDescriptor() {
                return modelDescriptor;
            }

            @Override
            public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
                if (productDescriptor instanceof SingleAssetProductDescriptor) {
                    return this.productFactory.getProductFromDescriptor(productDescriptor);
                }
                String name = modelDescriptor.name();
                throw new IllegalArgumentException("Unsupported product type " + name);
            }
        }
        return new HestonMonteCarloModel(model, new EulerSchemeFromProcessModel(model, this.brownianMotion));
    }
}

