/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.productfactory;

import java.time.LocalDate;
import net.finmath.fouriermethod.products.DigitalOption;
import net.finmath.fouriermethod.products.EuropeanOption;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.ProductFactory;
import net.finmath.modelling.SingleAssetProductDescriptor;
import net.finmath.modelling.descriptor.SingleAssetDigitalOptionProductDescriptor;
import net.finmath.modelling.descriptor.SingleAssetEuropeanOptionProductDescriptor;
import net.finmath.time.FloatingpointDate;

public class SingleAssetFourierProductFactory
implements ProductFactory<SingleAssetProductDescriptor> {
    private final LocalDate referenceDate;

    public SingleAssetFourierProductFactory(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    @Override
    public DescribedProduct<? extends SingleAssetProductDescriptor> getProductFromDescriptor(ProductDescriptor descriptor) {
        if (descriptor instanceof SingleAssetEuropeanOptionProductDescriptor) {
            EuropeanOptionFourierMethod product = new EuropeanOptionFourierMethod((SingleAssetEuropeanOptionProductDescriptor)descriptor, this.referenceDate);
            return product;
        }
        if (descriptor instanceof SingleAssetDigitalOptionProductDescriptor) {
            DigitalOptionFourierMethod product = new DigitalOptionFourierMethod((SingleAssetDigitalOptionProductDescriptor)descriptor, this.referenceDate);
            return product;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }

    public static class DigitalOptionFourierMethod
    extends DigitalOption
    implements DescribedProduct<SingleAssetDigitalOptionProductDescriptor> {
        private final SingleAssetDigitalOptionProductDescriptor descriptor;

        public DigitalOptionFourierMethod(SingleAssetDigitalOptionProductDescriptor descriptor, LocalDate referenceDate) {
            super(FloatingpointDate.getFloatingPointDateFromDate(referenceDate, descriptor.getMaturity()), descriptor.getStrike());
            this.descriptor = descriptor;
        }

        @Override
        public SingleAssetDigitalOptionProductDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class EuropeanOptionFourierMethod
    extends EuropeanOption
    implements DescribedProduct<SingleAssetEuropeanOptionProductDescriptor> {
        private final SingleAssetEuropeanOptionProductDescriptor descriptor;

        public EuropeanOptionFourierMethod(SingleAssetEuropeanOptionProductDescriptor descriptor, LocalDate referenceDate) {
            super(descriptor.getUnderlyingName(), FloatingpointDate.getFloatingPointDateFromDate(referenceDate, descriptor.getMaturity()), descriptor.getStrike());
            this.descriptor = descriptor;
        }

        @Override
        public SingleAssetEuropeanOptionProductDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

