/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.modelling.Model;
import net.finmath.montecarlo.MonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.stochastic.RandomVariable;

public abstract class AbstractMonteCarloProduct
implements MonteCarloProduct {
    private final String currency;

    public AbstractMonteCarloProduct(String currency) {
        this.currency = currency;
    }

    public AbstractMonteCarloProduct() {
        this(null);
    }

    @Override
    public Object getValue(double evaluationTime, Model model) {
        if (model instanceof MonteCarloSimulationModel) {
            try {
                return this.getValue(evaluationTime, (MonteCarloSimulationModel)model);
            }
            catch (CalculationException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("The product " + this.getClass() + " cannot be valued against a model " + model.getClass() + ".It requires a model of type " + MonteCarloSimulationModel.class + ".");
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, Model model) {
        Map<String, Object> results;
        if (model instanceof MonteCarloSimulationModel) {
            try {
                results = this.getValues(evaluationTime, (MonteCarloSimulationModel)model);
            }
            catch (CalculationException e) {
                results = new HashMap<String, Object>();
                results.put("exception", e);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException("The product " + this.getClass() + " cannot be valued against a model " + model.getClass() + ".It requires a model of type " + MonteCarloSimulationModel.class + ".");
            results = new HashMap<String, Object>();
            results.put("exception", e);
        }
        return results;
    }

    @Override
    public abstract RandomVariable getValue(double var1, MonteCarloSimulationModel var3) throws CalculationException;

    @Override
    public double getValue(MonteCarloSimulationModel model) throws CalculationException {
        return this.getValue(0.0, model).getAverage();
    }

    @Override
    public Map<String, Object> getValues(double evaluationTime, MonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = this.getValue(evaluationTime, model);
        if (values == null) {
            return null;
        }
        double value = values.getAverage();
        double error = values.getStandardError();
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("value", value);
        results.put("error", error);
        return results;
    }

    @Override
    public Map<String, Object> getValuesForModifiedData(double evaluationTime, MonteCarloSimulationModel model, Map<String, Object> dataModified) throws CalculationException {
        MonteCarloSimulationModel modelModified = model.getCloneWithModifiedData(dataModified);
        return this.getValues(evaluationTime, modelModified);
    }

    @Override
    public Map<String, Object> getValuesForModifiedData(double evaluationTime, MonteCarloSimulationModel model, String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getValuesForModifiedData(evaluationTime, model, dataModifiedMap);
    }

    @Override
    public Map<String, Object> getValues(MonteCarloSimulationModel model) throws CalculationException {
        return this.getValues(0.0, model);
    }

    @Override
    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationModel model, Map<String, Object> dataModified) throws CalculationException {
        return this.getValuesForModifiedData(0.0, model, dataModified);
    }

    @Override
    public Map<String, Object> getValuesForModifiedData(MonteCarloSimulationModel model, String entityKey, Object dataModified) throws CalculationException {
        return this.getValuesForModifiedData(0.0, model, entityKey, dataModified);
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public String toString() {
        return "AbstractMonteCarloProduct [currency=" + this.currency + "]";
    }
}

