/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotion;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class BrownianMotionView
implements BrownianMotion {
    private final BrownianMotion brownianMotion;
    private final Integer[] factors;

    public BrownianMotionView(BrownianMotion brownianMotion, Integer[] factors) {
        this.brownianMotion = brownianMotion;
        this.factors = factors;
    }

    @Override
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        return this.brownianMotion.getBrownianIncrement(timeIndex, (int)this.factors[factor]);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.brownianMotion.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factors.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.brownianMotion.getNumberOfPaths();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.brownianMotion.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedSeed(seed), this.factors);
    }

    @Override
    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new BrownianMotionView(this.brownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization), this.factors);
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }
}

