/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class CorrelatedBrownianMotion
implements BrownianMotion {
    private final BrownianMotion uncollelatedFactors;
    private final double[][] factorLoadings;

    public CorrelatedBrownianMotion(BrownianMotion uncollelatedFactors, double[][] factorLoadings) {
        this.uncollelatedFactors = uncollelatedFactors;
        this.factorLoadings = factorLoadings;
    }

    @Override
    public RandomVariable getBrownianIncrement(int timeIndex, int factor) {
        RandomVariable brownianIncrement = new RandomVariableFromDoubleArray(0.0);
        for (int factorIndex = 0; factorIndex < this.factorLoadings[factor].length; ++factorIndex) {
            if (this.factorLoadings[factor][factorIndex] == 0.0) continue;
            RandomVariable independentFactor = this.uncollelatedFactors.getBrownianIncrement(timeIndex, factorIndex);
            brownianIncrement = brownianIncrement.addProduct(independentFactor, this.factorLoadings[factor][factorIndex]);
        }
        return brownianIncrement;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.uncollelatedFactors.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorLoadings.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.uncollelatedFactors.getNumberOfPaths();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.uncollelatedFactors.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotion getCloneWithModifiedSeed(int seed) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedSeed(seed), this.factorLoadings);
    }

    @Override
    public BrownianMotion getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedTimeDiscretization(newTimeDiscretization), this.factorLoadings);
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }
}

