/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.randomnumbers.MersenneTwister;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class IndependentIncrementsFromICDF
implements IndependentIncrements,
Serializable {
    private static final long serialVersionUID = 6270884840989559532L;
    private final TimeDiscretization timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private final RandomVariableFactory abstractRandomVariableFactory;
    private transient RandomVariable[][] increments;
    private transient Object incrementsLazyInitLock = new Object();
    private final IntFunction<IntFunction<DoubleUnaryOperator>> inverseCumulativeDistributionFunctions;

    public IndependentIncrementsFromICDF(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, IntFunction<IntFunction<DoubleUnaryOperator>> inverseCumulativeDistributionFunctions, RandomVariableFactory abstractRandomVariableFactory) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = numberOfFactors;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.inverseCumulativeDistributionFunctions = inverseCumulativeDistributionFunctions;
        this.abstractRandomVariableFactory = abstractRandomVariableFactory;
        this.increments = null;
    }

    public IndependentIncrementsFromICDF(TimeDiscretization timeDiscretization, int numberOfFactors, int numberOfPaths, int seed, IntFunction<IntFunction<DoubleUnaryOperator>> inverseCumulativeDistributionFunctions) {
        this(timeDiscretization, numberOfFactors, numberOfPaths, seed, inverseCumulativeDistributionFunctions, new RandomVariableFromArrayFactory());
    }

    @Override
    public IndependentIncrements getCloneWithModifiedSeed(int seed) {
        return new IndependentIncrementsFromICDF(this.getTimeDiscretization(), this.getNumberOfFactors(), this.getNumberOfPaths(), seed, this.inverseCumulativeDistributionFunctions, this.abstractRandomVariableFactory);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return new IndependentIncrementsFromICDF(newTimeDiscretization, this.getNumberOfFactors(), this.getNumberOfPaths(), this.getSeed(), this.inverseCumulativeDistributionFunctions, this.abstractRandomVariableFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        Object object = this.incrementsLazyInitLock;
        synchronized (object) {
            if (this.increments == null) {
                this.doGenerateIncrements();
            }
        }
        return this.increments[timeIndex][factor];
    }

    private void doGenerateIncrements() {
        int timeIndex;
        if (this.increments != null) {
            return;
        }
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        double[][][] incrementsArray = new double[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors][this.numberOfPaths];
        DoubleUnaryOperator[][] inverseCumulativeDistributionFunctions = new DoubleUnaryOperator[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                inverseCumulativeDistributionFunctions[timeIndex][factor] = this.inverseCumulativeDistributionFunctions.apply(timeIndex).apply(factor);
            }
        }
        for (int path = 0; path < this.numberOfPaths; ++path) {
            for (int timeIndex2 = 0; timeIndex2 < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex2) {
                for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                    double uniformIncrement = mersenneTwister.nextDouble();
                    incrementsArray[timeIndex2][factor][path] = inverseCumulativeDistributionFunctions[timeIndex2][factor].applyAsDouble(uniformIncrement);
                }
            }
        }
        this.increments = new RandomVariable[this.timeDiscretization.getNumberOfTimeSteps()][this.numberOfFactors];
        for (timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIndex) {
            double time = this.timeDiscretization.getTime(timeIndex + 1);
            for (int factor = 0; factor < this.numberOfFactors; ++factor) {
                this.increments[timeIndex][factor] = this.abstractRandomVariableFactory.createRandomVariable(time, incrementsArray[timeIndex][factor]);
            }
        }
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.abstractRandomVariableFactory.createRandomVariable(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public String toString() {
        return super.toString() + "\ntimeDiscretizationFromArray: " + this.timeDiscretization.toString() + "\nnumberOfPaths: " + this.numberOfPaths + "\nnumberOfFactors: " + this.numberOfFactors + "\nseed: " + this.seed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndependentIncrementsFromICDF that = (IndependentIncrementsFromICDF)o;
        if (this.numberOfFactors != that.numberOfFactors) {
            return false;
        }
        if (this.numberOfPaths != that.numberOfPaths) {
            return false;
        }
        if (this.seed != that.seed) {
            return false;
        }
        return this.timeDiscretization.equals(that.timeDiscretization);
    }

    public int hashCode() {
        int result = this.timeDiscretization.hashCode();
        result = 31 * result + this.numberOfFactors;
        result = 31 * result + this.numberOfPaths;
        result = 31 * result + this.seed;
        return result;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.incrementsLazyInitLock = new Object();
    }
}

