/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.io.Serializable;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import net.finmath.functions.NormalDistribution;
import net.finmath.functions.PoissonDistribution;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.IndependentIncrementsFromICDF;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MertonJumpProcess
implements IndependentIncrements,
Serializable {
    private static final long serialVersionUID = -6984273344382051927L;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private final IndependentIncrements internalProcess;
    private final double jumpIntensity;
    private final double jumpSizeMean;
    private final double jumpSizeStDev;

    public MertonJumpProcess(final double jumpIntensity, double jumpSizeMean, double jumpSizeStDev, final TimeDiscretization timeDiscretization, int numberOfPaths, int seed) {
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStDev = jumpSizeStDev;
        IntFunction<IntFunction<DoubleUnaryOperator>> inverseCumulativeDistributionFunctions = new IntFunction<IntFunction<DoubleUnaryOperator>>(){

            @Override
            public IntFunction<DoubleUnaryOperator> apply(final int i) {
                return new IntFunction<DoubleUnaryOperator>(){

                    @Override
                    public DoubleUnaryOperator apply(int j) {
                        if (j == 0) {
                            final double sqrtOfTimeStep = Math.sqrt(timeDiscretization.getTimeStep(i));
                            return new DoubleUnaryOperator(){

                                @Override
                                public double applyAsDouble(double x) {
                                    return NormalDistribution.inverseCumulativeDistribution(x) * sqrtOfTimeStep;
                                }
                            };
                        }
                        if (j == 1) {
                            return new DoubleUnaryOperator(){

                                @Override
                                public double applyAsDouble(double x) {
                                    return NormalDistribution.inverseCumulativeDistribution(x);
                                }
                            };
                        }
                        if (j == 2) {
                            double timeStep = timeDiscretization.getTimeStep(i);
                            final PoissonDistribution poissonDistribution = new PoissonDistribution(jumpIntensity * timeStep);
                            return new DoubleUnaryOperator(){

                                @Override
                                public double applyAsDouble(double x) {
                                    return poissonDistribution.inverseCumulativeDistribution(x);
                                }
                            };
                        }
                        return null;
                    }
                };
            }
        };
        IndependentIncrementsFromICDF icrements = new IndependentIncrementsFromICDF(timeDiscretization, 3, numberOfPaths, seed, inverseCumulativeDistributionFunctions){
            private static final long serialVersionUID = -7858107751226404629L;

            @Override
            public RandomVariable getIncrement(int timeIndex, int factor) {
                if (factor == 1) {
                    RandomVariable Z = super.getIncrement(timeIndex, 1);
                    RandomVariable N = super.getIncrement(timeIndex, 2);
                    return Z.mult(N.sqrt());
                }
                return super.getIncrement(timeIndex, factor);
            }
        };
        this.internalProcess = icrements;
    }

    @Override
    public RandomVariable getIncrement(int timeIndex, int factor) {
        return this.internalProcess.getIncrement(timeIndex, factor);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.internalProcess.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.internalProcess.getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.internalProcess.getNumberOfPaths();
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedSeed(int seed) {
        return this.internalProcess.getCloneWithModifiedSeed(seed);
    }

    @Override
    public IndependentIncrements getCloneWithModifiedTimeDiscretization(TimeDiscretization newTimeDiscretization) {
        return this.internalProcess.getCloneWithModifiedTimeDiscretization(newTimeDiscretization);
    }

    public double getJumpIntensity() {
        return this.jumpIntensity;
    }

    public double getJumpSizeMean() {
        return this.jumpSizeMean;
    }

    public double getJumpSizeStDev() {
        return this.jumpSizeStDev;
    }
}

