/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.RandomVariableFromFloatArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class RandomVariableFromArrayFactory
extends AbstractRandomVariableFactory {
    private static final long serialVersionUID = 9124600813005863273L;
    private final boolean isUseDoublePrecisionFloatingPointImplementation;

    public RandomVariableFromArrayFactory() {
        this.isUseDoublePrecisionFloatingPointImplementation = true;
    }

    public RandomVariableFromArrayFactory(boolean isUseDoublePrecisionFloatingPointImplementation) {
        this.isUseDoublePrecisionFloatingPointImplementation = isUseDoublePrecisionFloatingPointImplementation;
    }

    @Override
    public RandomVariable createRandomVariable(double value) {
        return new Scalar(value);
    }

    @Override
    public RandomVariable createRandomVariable(double time, double value) {
        return new Scalar(value);
    }

    @Override
    public RandomVariable createRandomVariable(double time, double[] values) {
        if (this.isUseDoublePrecisionFloatingPointImplementation) {
            return new RandomVariableFromDoubleArray(time, values);
        }
        return new RandomVariableFromFloatArray(time, values);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [isUseDoublePrecisionFloatingPointImplementation=" + this.isUseDoublePrecisionFloatingPointImplementation + "]";
    }
}

