/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloBlackScholesModel
implements AssetModelMonteCarloSimulationModel {
    private final BlackScholesModel model;
    private final MonteCarloProcess process;
    private static final int seed = 3141;

    public MonteCarloBlackScholesModel(double initialValue, double riskFreeRate, double volatility, BrownianMotion brownianMotion) {
        this.model = new BlackScholesModel(initialValue, riskFreeRate, volatility);
        this.process = new EulerSchemeFromProcessModel(this.model, brownianMotion);
    }

    public MonteCarloBlackScholesModel(TimeDiscretization timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility) {
        this(initialValue, riskFreeRate, volatility, new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, 1, numberOfPaths, 3141));
    }

    private MonteCarloBlackScholesModel(BlackScholesModel model, MonteCarloProcess process) {
        this.model = model;
        this.process = process;
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.getTime(timeIndex);
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        ProcessModel newModel = this.model.getCloneWithModifiedData((Map)dataModified);
        int newSeed = dataModified.get("seed") != null ? ((Number)dataModified.get("seed")).intValue() : 3141;
        BrownianMotion newBrownianMotion = dataModified.get("seed") != null ? new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), newSeed) : (BrownianMotion)this.process.getStochasticDriver();
        double newInitialTime = dataModified.get("initialTime") != null ? ((Number)dataModified.get("initialTime")).doubleValue() : this.getTime(0);
        double timeShift = newInitialTime - this.getTime(0);
        if (timeShift != 0.0) {
            TimeDiscretization newTimeDiscretization = this.process.getStochasticDriver().getTimeDiscretization().getTimeShiftedTimeDiscretization(timeShift);
            newBrownianMotion = newBrownianMotion.getCloneWithModifiedTimeDiscretization(newTimeDiscretization);
        }
        EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(this.getModel(), new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), 3141));
        return new MonteCarloBlackScholesModel((BlackScholesModel)newModel, process);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        EulerSchemeFromProcessModel process = new EulerSchemeFromProcessModel(this.getModel(), new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), 1, this.getNumberOfPaths(), seed));
        return new MonteCarloBlackScholesModel(this.model, process);
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public LocalDateTime getReferenceDate() {
        return this.model.getReferenceDate();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.model.getRandomVariableForConstant(value);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    public BlackScholesModel getModel() {
        return this.model;
    }

    public MonteCarloProcess getProcess() {
        return this.process;
    }
}

