/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.functions.LinearAlgebra;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloMultiAssetBlackScholesModel
extends AbstractProcessModel
implements AssetModelMonteCarloSimulationModel {
    private final MonteCarloProcess process;
    private final RandomVariableFactory randomVariableFactory = new RandomVariableFromArrayFactory();
    private final double[] initialValues;
    private final double riskFreeRate;
    private final double[] volatilities;
    private final double[][] factorLoadings;
    private static final int seed = 3141;
    private final RandomVariable[] initialStates;
    private final RandomVariable[] drift;
    private final RandomVariable[][] factorLoadingOnPaths;

    public MonteCarloMultiAssetBlackScholesModel(BrownianMotion brownianMotion, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this.process = new EulerSchemeFromProcessModel(this, brownianMotion, EulerSchemeFromProcessModel.Scheme.EULER_FUNCTIONAL);
        this.initialValues = initialValues;
        this.riskFreeRate = riskFreeRate;
        this.volatilities = volatilities;
        this.factorLoadings = LinearAlgebra.getFactorMatrix(correlations, correlations.length);
        this.initialStates = new RandomVariable[this.getNumberOfComponents()];
        this.drift = new RandomVariable[this.getNumberOfComponents()];
        this.factorLoadingOnPaths = new RandomVariable[this.getNumberOfComponents()][];
        for (int underlyingIndex = 0; underlyingIndex < initialValues.length; ++underlyingIndex) {
            this.initialStates[underlyingIndex] = this.getRandomVariableForConstant(Math.log(initialValues[underlyingIndex]));
            this.drift[underlyingIndex] = this.getRandomVariableForConstant(riskFreeRate - volatilities[underlyingIndex] * volatilities[underlyingIndex] / 2.0);
            this.factorLoadingOnPaths[underlyingIndex] = new RandomVariable[this.process.getNumberOfFactors()];
            for (int factorIndex = 0; factorIndex < this.process.getNumberOfFactors(); ++factorIndex) {
                this.factorLoadingOnPaths[underlyingIndex][factorIndex] = this.getRandomVariableForConstant(volatilities[underlyingIndex] * this.factorLoadings[underlyingIndex][factorIndex]);
            }
        }
    }

    public MonteCarloMultiAssetBlackScholesModel(TimeDiscretization timeDiscretization, int numberOfPaths, double[] initialValues, double riskFreeRate, double[] volatilities, double[][] correlations) {
        this(new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, initialValues.length, numberOfPaths, 3141), initialValues, riskFreeRate, volatilities, correlations);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return this.initialStates;
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.factorLoadingOnPaths[component];
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1;
        }
        return this.getAssetValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) throws CalculationException {
        return this.process.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.process.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return this.getRandomVariableForConstant(numeraireValue);
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) throws CalculationException {
        double time = this.process.getTime(timeIndex);
        return this.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.getNumeraire(this.process, time);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public int getNumberOfComponents() {
        return this.initialValues.length;
    }

    @Override
    public int getNumberOfAssets() {
        return this.getNumberOfComponents();
    }

    public String toString() {
        return "MonteCarloMultiAssetBlackScholesModel [initialValues=" + Arrays.toString(this.initialValues) + ", riskFreeRate=" + this.riskFreeRate + ", volatilities=" + Arrays.toString(this.volatilities) + ", factorLoadings=" + Arrays.toString((Object[])this.factorLoadings) + "]";
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double[] getVolatilities() {
        return this.volatilities;
    }

    @Override
    public int getNumberOfPaths() {
        return this.process.getNumberOfPaths();
    }

    @Override
    public MonteCarloMultiAssetBlackScholesModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        double[] newInitialValues = this.initialValues;
        double newRiskFreeRate = this.riskFreeRate;
        double[] newVolatilities = this.volatilities;
        double[][] newCorrelations = null;
        if (dataModified.containsKey("initialValues")) {
            newInitialValues = (double[])dataModified.get("initialValues");
        }
        if (dataModified.containsKey("riskFreeRate")) {
            newRiskFreeRate = (Double)dataModified.get("riskFreeRate");
        }
        if (dataModified.containsKey("volatilities")) {
            newVolatilities = (double[])dataModified.get("volatilities");
        }
        if (dataModified.containsKey("correlations")) {
            newCorrelations = (double[][])dataModified.get("correlations");
        }
        return new MonteCarloMultiAssetBlackScholesModel(this.getTimeDiscretization(), this.getNumberOfPaths(), newInitialValues, newRiskFreeRate, newVolatilities, newCorrelations);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        HashMap<String, Integer> dataModified = new HashMap<String, Integer>();
        dataModified.put("seed", new Integer(seed));
        return this.getCloneWithModifiedData(dataModified);
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.process.getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.process.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.process.getTimeIndex(time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.process.getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.process.getNumberOfFactors();
    }
}

