/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;

public class DisplacedLognomalModel
extends AbstractProcessModel {
    private final RandomVariableFactory randomVariableFactory;
    private final RandomVariable initialValue;
    private final RandomVariable riskFreeRate;
    private final RandomVariable displacement;
    private final RandomVariable volatility;

    public DisplacedLognomalModel(RandomVariableFactory randomVariableFactory, RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable displacement, RandomVariable volatility) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.displacement = displacement;
        this.volatility = volatility;
    }

    public DisplacedLognomalModel(RandomVariableFactory randomVariableFactory, double initialValue, double riskFreeRate, double displacement, double volatility) {
        this(randomVariableFactory, randomVariableFactory.createRandomVariable(initialValue), randomVariableFactory.createRandomVariable(riskFreeRate), randomVariableFactory.createRandomVariable(displacement), randomVariableFactory.createRandomVariable(volatility));
    }

    public DisplacedLognomalModel(double initialValue, double riskFreeRate, double displacement, double volatility) {
        this((RandomVariableFactory)new RandomVariableFromArrayFactory(), initialValue, riskFreeRate, displacement, volatility);
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue.add(this.displacement).log()};
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable[] drift = new RandomVariable[realizationAtTimeIndex.length];
        for (int componentIndex = 0; componentIndex < realizationAtTimeIndex.length; ++componentIndex) {
            drift[componentIndex] = this.volatility.squared().mult(-0.5);
        }
        return drift;
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int component, RandomVariable[] realizationAtTimeIndex) {
        return new RandomVariable[]{this.volatility};
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        double time = process.getTime(timeIndex);
        return randomVariable.exp().sub(this.displacement).mult(this.riskFreeRate.mult(time).exp());
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        double time = process.getTime(timeIndex);
        return randomVariable.div(this.riskFreeRate.mult(time).exp()).add(this.displacement).log();
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        return this.riskFreeRate.mult(time).exp();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public DisplacedLognomalModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        RandomVariable newInitialValue = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("initialValue"), this.initialValue);
        RandomVariable newRiskFreeRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.riskFreeRate);
        RandomVariable newDisplacement = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("displacement"), this.displacement);
        RandomVariable newVolatility = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("volatility"), this.volatility);
        return new DisplacedLognomalModel(newRandomVariableFactory, newInitialValue, newRiskFreeRate, newDisplacement, newVolatility);
    }

    public String toString() {
        return "DisplacedLognomalModelExperimental [randomVariableFactory=" + this.randomVariableFactory + ", initialValue=" + this.initialValue + ", riskFreeRate=" + this.riskFreeRate + ", displacement=" + this.displacement + ", volatility=" + this.volatility + "]";
    }

    public RandomVariableFactory getRandomVariableFactory() {
        return this.randomVariableFactory;
    }

    public RandomVariable getInitialValue() {
        return this.initialValue;
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariable getDisplacement() {
        return this.displacement;
    }

    public RandomVariable getVolatility() {
        return this.volatility;
    }
}

