/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.models;

import java.util.Map;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.MertonModelDescriptor;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.model.AbstractProcessModel;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class MertonModel
extends AbstractProcessModel {
    private static final RandomVariable ZERO = new Scalar(0.0);
    private final RandomVariable initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final RandomVariable riskFreeRate;
    private final RandomVariable volatility;
    private final DiscountCurve discountCurveForDiscountRate;
    private final RandomVariable discountRate;
    private final RandomVariable jumpIntensity;
    private final RandomVariable jumpSizeMean;
    private final RandomVariable jumpSizeStdDev;
    private final RandomVariableFactory randomVariableFactory;

    public MertonModel(RandomVariable initialValue, DiscountCurve discountCurveForForwardRate, RandomVariable volatility, DiscountCurve discountCurveForDiscountRate, RandomVariable jumpIntensity, RandomVariable jumpSizeMean, RandomVariable jumpSizeStDev, RandomVariableFactory randomVariableFactory) {
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = null;
        this.volatility = volatility;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = null;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStDev;
        this.randomVariableFactory = randomVariableFactory;
    }

    public MertonModel(double initialValue, DiscountCurve discountCurveForForwardRate, double volatility, DiscountCurve discountCurveForDiscountRate, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev, RandomVariableFactory randomVariableFactory) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = randomVariableFactory.createRandomVariable(initialValue);
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = null;
        this.volatility = randomVariableFactory.createRandomVariable(volatility);
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = null;
        this.jumpIntensity = randomVariableFactory.createRandomVariable(jumpIntensity);
        this.jumpSizeMean = randomVariableFactory.createRandomVariable(jumpSizeMean);
        this.jumpSizeStdDev = randomVariableFactory.createRandomVariable(jumpSizeStDev);
    }

    public MertonModel(RandomVariable initialValue, RandomVariable riskFreeRate, RandomVariable volatility, RandomVariable discountRate, RandomVariable jumpIntensity, RandomVariable jumpSizeMean, RandomVariable jumpSizeStDev, RandomVariableFactory randomVariableFactory) {
        this.randomVariableFactory = randomVariableFactory;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStDev;
    }

    public MertonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev, RandomVariableFactory randomVariableFactory) {
        this(randomVariableFactory.createRandomVariable(initialValue), randomVariableFactory.createRandomVariable(riskFreeRate), randomVariableFactory.createRandomVariable(volatility), randomVariableFactory.createRandomVariable(discountRate), randomVariableFactory.createRandomVariable(jumpIntensity), randomVariableFactory.createRandomVariable(jumpSizeMean), randomVariableFactory.createRandomVariable(jumpSizeStDev), randomVariableFactory);
    }

    public MertonModel(MertonModelDescriptor descriptor) {
        this((double)descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), (double)descriptor.getVolatility(), descriptor.getDiscountCurveForDiscountRate(), (double)descriptor.getJumpIntensity(), (double)descriptor.getJumpSizeMean(), (double)descriptor.getJumpSizeStdDev());
    }

    public MertonModel(double initialValue, DiscountCurve discountCurveForForwardRate, double volatility, DiscountCurve discountCurveForDiscountRate, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this(initialValue, discountCurveForForwardRate, volatility, discountCurveForDiscountRate, jumpIntensity, jumpSizeMean, jumpSizeStDev, (RandomVariableFactory)new RandomVariableFromArrayFactory());
    }

    public MertonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this(initialValue, riskFreeRate, volatility, discountRate, jumpIntensity, jumpSizeMean, jumpSizeStDev, (RandomVariableFactory)new RandomVariableFromArrayFactory());
    }

    public MertonModel(double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStDev) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate, jumpIntensity, jumpSizeMean, jumpSizeStDev);
    }

    @Override
    public RandomVariable applyStateSpaceTransform(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.exp();
    }

    @Override
    public RandomVariable applyStateSpaceTransformInverse(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable randomVariable) {
        return randomVariable.log();
    }

    @Override
    public RandomVariable[] getInitialState(MonteCarloProcess process) {
        return new RandomVariable[]{this.initialValue.log()};
    }

    @Override
    public RandomVariable getNumeraire(MonteCarloProcess process, double time) {
        if (this.discountCurveForDiscountRate != null) {
            return this.getRandomVariableForConstant(1.0 / this.discountCurveForDiscountRate.getDiscountFactor(time));
        }
        return this.discountRate.mult(time).exp();
    }

    @Override
    public RandomVariable[] getDrift(MonteCarloProcess process, int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable riskFreeRateAtTimeStep;
        if (this.discountCurveForForwardRate != null) {
            double time = process.getTime(timeIndex);
            double timeNext = process.getTime(timeIndex + 1);
            riskFreeRateAtTimeStep = this.getRandomVariableForConstant(Math.log(this.discountCurveForForwardRate.getDiscountFactor(time) / this.discountCurveForForwardRate.getDiscountFactor(timeNext)) / (timeNext - time));
        } else {
            riskFreeRateAtTimeStep = this.riskFreeRate;
        }
        return new RandomVariable[]{riskFreeRateAtTimeStep.sub(this.jumpSizeMean.exp().sub(1.0).mult(this.jumpIntensity)).sub(this.volatility.squared().div(2.0))};
    }

    @Override
    public RandomVariable[] getFactorLoading(MonteCarloProcess process, int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex) {
        RandomVariable[] factors = new RandomVariable[]{this.volatility, this.jumpSizeStdDev, this.jumpSizeMean.sub(this.jumpSizeStdDev.squared().div(2.0))};
        return factors;
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public int getNumberOfFactors() {
        return 1;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public ProcessModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        RandomVariableFactory newRandomVariableFactory = (RandomVariableFactory)dataModified.getOrDefault("randomVariableFactory", this.randomVariableFactory);
        RandomVariable newInitialValue = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("initialValue"), this.initialValue);
        RandomVariable newRiskFreeRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.riskFreeRate);
        RandomVariable newVolatility = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("volatility"), this.volatility);
        RandomVariable newDiscountRate = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("discountRate"), this.discountRate);
        RandomVariable newJumpIntensity = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("riskFreeRate"), this.jumpIntensity);
        RandomVariable newJumpSizeMean = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("jumpSizeMean"), this.jumpSizeMean);
        RandomVariable newJumpSizeStDev = RandomVariableFactory.getRandomVariableOrDefault(newRandomVariableFactory, dataModified.get("jumpSizeStdDev"), this.jumpSizeStdDev);
        return new MertonModel(newInitialValue, newRiskFreeRate, newVolatility, newDiscountRate, newJumpIntensity, newJumpSizeMean, newJumpSizeStDev, newRandomVariableFactory);
    }

    public RandomVariable getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public RandomVariable getVolatility() {
        return this.volatility;
    }

    public RandomVariable getJumpIntensity() {
        return this.jumpIntensity;
    }

    public RandomVariable getJumpSizeMean() {
        return this.jumpSizeMean;
    }

    public RandomVariable getJumpSizeStdDev() {
        return this.jumpSizeStdDev;
    }
}

