/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class BlackScholesDeltaHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final double riskFreeRate;
    private final double volatility;

    public BlackScholesDeltaHedgedPortfolio(double maturity, double strike, double riskFreeRate, double volatility) {
        this.maturity = maturity;
        this.strike = strike;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        RandomVariable underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireToday = model.getNumeraire(0.0);
        RandomVariable valueOfOptionAccordingBlackScholes = AnalyticFormulas.blackScholesGeneralizedOptionValue(underlyingToday.mult(Math.exp(this.riskFreeRate * (this.maturity - 0.0))), model.getRandomVariableForConstant(this.volatility), this.maturity - 0.0, this.strike, model.getRandomVariableForConstant(Math.exp(-this.riskFreeRate * (this.maturity - 0.0))));
        RandomVariable amountOfNumeraireAsset = valueOfOptionAccordingBlackScholes.div(numeraireToday);
        RandomVariable amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariable newNumberOfNumeraireAsset;
            RandomVariable delta;
            RandomVariable underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariable numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            RandomVariable newNumberOfStocks = delta = AnalyticFormulas.blackScholesOptionDelta(underlyingAtTimeIndex, model.getRandomVariableForConstant(this.riskFreeRate), model.getRandomVariableForConstant(this.volatility), this.maturity - model.getTime(timeIndex), this.strike);
            RandomVariable stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariable numeraireAssetsToSell = stocksToBuy.mult(underlyingAtTimeIndex).div(numeraireAtTimeIndex);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.sub(numeraireAssetsToSell);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariable underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }
}

