/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.assetderivativevaluation.products.AssetMonteCarloProduct;
import net.finmath.montecarlo.assetderivativevaluation.products.BermudanOption;
import net.finmath.montecarlo.automaticdifferentiation.RandomVariableDifferentiable;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.stochastic.RandomVariable;

public class DeltaHedgedPortfolioWithAAD
extends AbstractAssetMonteCarloProduct {
    private final AssetMonteCarloProduct productToReplicate;
    private int numberOfRegressionFunctions = 20;
    private double lastOperationTimingValuation = Double.NaN;
    private double lastOperationTimingDerivative = Double.NaN;

    public DeltaHedgedPortfolioWithAAD(AssetMonteCarloProduct productToReplicate, int numberOfBins) {
        this.productToReplicate = productToReplicate;
        this.numberOfRegressionFunctions = numberOfBins;
    }

    public DeltaHedgedPortfolioWithAAD(AssetMonteCarloProduct productToReplicate) {
        this.productToReplicate = productToReplicate;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        long timingValuationStart = System.currentTimeMillis();
        RandomVariableDifferentiable value = (RandomVariableDifferentiable)this.productToReplicate.getValue(model.getTime(0), model);
        RandomVariable exerciseTime = null;
        if (this.productToReplicate instanceof BermudanOption) {
            exerciseTime = ((BermudanOption)this.productToReplicate).getLastValuationExerciseTime();
        }
        long timingValuationEnd = System.currentTimeMillis();
        RandomVariable valueOfOption = model.getRandomVariableForConstant(value.getAverage());
        RandomVariable underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireToday = model.getNumeraire(0.0);
        RandomVariable amountOfNumeraireAsset = valueOfOption.div(numeraireToday);
        RandomVariable amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        long timingDerivativeStart = System.currentTimeMillis();
        Map<Long, RandomVariable> gradient = value.getGradient();
        long timingDerivativeEnd = System.currentTimeMillis();
        this.lastOperationTimingValuation = (double)(timingValuationEnd - timingValuationStart) / 1000.0;
        this.lastOperationTimingDerivative = (double)(timingDerivativeEnd - timingDerivativeStart) / 1000.0;
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            RandomVariable newNumberOfNumeraireAsset;
            RandomVariable underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariable numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            RandomVariable delta = gradient.get(((RandomVariableDifferentiable)underlyingAtTimeIndex).getID());
            if (delta == null) {
                delta = underlyingAtTimeIndex.mult(0.0);
            }
            delta = delta.mult(numeraireAtTimeIndex);
            RandomVariable indicator = new RandomVariableFromDoubleArray(1.0);
            if (exerciseTime != null) {
                indicator = exerciseTime.sub(model.getTime(timeIndex) + 0.001).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0));
            }
            ArrayList<RandomVariable> basisFunctions = this.getRegressionBasisFunctionsBinning(underlyingAtTimeIndex, indicator);
            MonteCarloConditionalExpectationRegression conditionalExpectationOperator = new MonteCarloConditionalExpectationRegression(basisFunctions.toArray(new RandomVariable[0]));
            RandomVariable newNumberOfStocks = delta = delta.getConditionalExpectation(conditionalExpectationOperator);
            RandomVariable stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariable numeraireAssetsToSell = stocksToBuy.mult(underlyingAtTimeIndex).div(numeraireAtTimeIndex);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.sub(numeraireAssetsToSell);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariable underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariable portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }

    public double getLastOperationTimingValuation() {
        return this.lastOperationTimingValuation;
    }

    public double getLastOperationTimingDerivative() {
        return this.lastOperationTimingDerivative;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctions(RandomVariable underlying, RandomVariable indicator) {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        for (int powerOfRegressionMonomial = 0; powerOfRegressionMonomial < this.numberOfRegressionFunctions; ++powerOfRegressionMonomial) {
            basisFunctions.add(underlying.pow(powerOfRegressionMonomial).mult(indicator));
        }
        return basisFunctions;
    }

    private ArrayList<RandomVariable> getRegressionBasisFunctionsBinning(RandomVariable underlying, RandomVariable indicator) {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        if (underlying.isDeterministic()) {
            basisFunctions.add(underlying);
        } else {
            double[] values = underlying.getRealizations();
            Arrays.sort(values);
            for (int i = 0; i < this.numberOfRegressionFunctions; ++i) {
                double binLeft = values[(int)((double)i / (double)this.numberOfRegressionFunctions * (double)values.length)];
                RandomVariable basisFunction = underlying.sub(binLeft).choose(new RandomVariableFromDoubleArray(1.0), new RandomVariableFromDoubleArray(0.0)).mult(indicator);
                basisFunctions.add(basisFunction);
            }
        }
        return basisFunctions;
    }
}

