/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class EuropeanOptionDeltaLikelihood
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final boolean isLikelihoodByFiniteDifference = true;

    public EuropeanOptionDeltaLikelihood(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        BlackScholesModel blackScholesModel;
        try {
            blackScholesModel = (BlackScholesModel)((MonteCarloAssetModel)model).getModel();
        }
        catch (Exception e) {
            throw new ClassCastException("This method requires a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable underlyingAtToday = model.getAssetValue(evaluationTime, 0);
        RandomVariable r = blackScholesModel.getRiskFreeRate();
        RandomVariable sigma = blackScholesModel.getVolatility();
        double T = this.maturity;
        double h = 1.0E-6;
        RandomVariable x1 = underlyingAtMaturity.div(underlyingAtToday).log().sub(r.mult(T).sub(sigma.squared().mult(0.5 * T))).div(sigma).div(Math.sqrt(T));
        RandomVariable logPhi1 = x1.squared().div(-2.0).exp().div(Math.sqrt(Math.PI * 2)).div(underlyingAtMaturity).div(sigma).div(Math.sqrt(T)).log();
        RandomVariable x2 = underlyingAtMaturity.div(underlyingAtToday.add(1.0E-6)).log().sub(r.mult(T).sub(sigma.squared().mult(0.5 * T))).div(sigma).div(Math.sqrt(T));
        RandomVariable logPhi2 = x2.squared().div(-2.0).exp().div(Math.sqrt(Math.PI * 2)).div(underlyingAtMaturity).div(sigma).div(Math.sqrt(T)).log();
        RandomVariable likelihoodRatio = logPhi2.sub(logPhi1).div(1.0E-6);
        RandomVariable values = underlyingAtMaturity.sub(this.strike).floor(0.0).mult(likelihoodRatio);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }
}

