/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.RandomVariableAccumulator;

public class EuropeanOptionRhoPathwise
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;

    public EuropeanOptionRhoPathwise(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    public double getValue(AssetModelMonteCarloSimulationModel model) throws CalculationException {
        MonteCarloBlackScholesModel blackScholesModel = null;
        try {
            blackScholesModel = (MonteCarloBlackScholesModel)model;
        }
        catch (Exception e) {
            throw new ClassCastException("This method requires a Black-Scholes type model (MonteCarloBlackScholesModel).");
        }
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable underlyingAtToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireAtToday = model.getNumeraire(0);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        double average = 0.0;
        for (int path = 0; path < model.getNumberOfPaths(); ++path) {
            if (!(underlyingAtMaturity.get(path) > this.strike)) continue;
            double T = this.maturity;
            double ST = underlyingAtMaturity.get(path);
            double payOff = 1.0;
            double modifiedPayoff = 1.0 * ST * T - (ST - this.strike) * T;
            average += modifiedPayoff / numeraireAtMaturity.get(path) * monteCarloWeights.get(path) * numeraireAtToday.get(path);
        }
        return average;
    }

    @Override
    public RandomVariableAccumulator getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) {
        throw new RuntimeException("Method not supported.");
    }
}

