/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloBlackScholesModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.montecarlo.process.component.barrier.Barrier;
import net.finmath.stochastic.RandomVariable;

public class EuropeanOptionWithBoundary
extends AbstractAssetMonteCarloProduct {
    private final double boundary = 4.0;
    private final boolean isBoundaryTimeDep = true;
    private final BoundaryAdjustmentType boundaryAdjustmentType = BoundaryAdjustmentType.LINEAR_REGRESSED;
    private final double maturity;
    private final double strike;

    public EuropeanOptionWithBoundary(double maturity, double strike) {
        this.maturity = maturity;
        this.strike = strike;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable underlyingAtMaturity = model.getAssetValue(this.maturity, 0);
        RandomVariable values = underlyingAtMaturity.sub(this.strike).floor(0.0);
        RandomVariable numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariable monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariable numeraireAtZero = model.getNumeraire(evaluationTime);
        RandomVariable monteCarloProbabilitiesAtZero = model.getMonteCarloWeights(evaluationTime);
        values.mult(numeraireAtZero).div(monteCarloProbabilitiesAtZero);
        RandomVariableFromDoubleArray prob = new RandomVariableFromDoubleArray(0.0, 1.0);
        prob.mult(monteCarloWeights).div(monteCarloProbabilitiesAtZero);
        prob.sub(1.0);
        prob.mult(-1.0);
        values.add(this.getBoundaryAdjustment(evaluationTime, this.maturity, model, values));
        return values;
    }

    public RandomVariable getBoundaryAdjustment(double fromTime, double toTime, AssetModelMonteCarloSimulationModel model, RandomVariable continuationValues) throws CalculationException {
        double riskFreeRate;
        RandomVariableFromDoubleArray values = new RandomVariableFromDoubleArray(0.0, 0.0);
        int fromTimeIndex = model.getTimeIndex(fromTime);
        double fromTimeNext = model.getTime(fromTimeIndex + 1);
        if (fromTimeNext < toTime) {
            RandomVariable monteCarloProbabilitiesEnd = model.getMonteCarloWeights(fromTimeNext);
            RandomVariable monteCarloProbabilitiesStart = model.getMonteCarloWeights(fromTime);
            RandomVariable monteCarloProbabilitiesTransition = monteCarloProbabilitiesEnd.div(monteCarloProbabilitiesStart);
            riskFreeRate = ((MonteCarloBlackScholesModel)model).getModel().getRiskFreeRate().doubleValue();
            RandomVariable remainingBoundaryAdjustment = this.getBoundaryAdjustment(fromTimeNext, toTime, model, continuationValues);
            remainingBoundaryAdjustment.mult(monteCarloProbabilitiesTransition).mult(Math.exp(-riskFreeRate * (fromTimeNext - fromTime)));
            values.add(remainingBoundaryAdjustment);
        }
        MonteCarloBlackScholesModel modelBlackScholes = (MonteCarloBlackScholesModel)model;
        double spot = modelBlackScholes.getModel().getInitialState(modelBlackScholes.getProcess())[0].doubleValue();
        riskFreeRate = modelBlackScholes.getModel().getRiskFreeRate().doubleValue();
        double volatility = modelBlackScholes.getModel().getVolatility().doubleValue();
        double boundaryLocal = spot * Math.exp(riskFreeRate * this.maturity + 1.0 * Math.sqrt(this.maturity));
        boundaryLocal = spot * Math.exp(riskFreeRate * fromTimeNext + 1.0 * Math.sqrt(fromTimeNext));
        RandomVariable underlying = model.getAssetValue(fromTime, 0);
        double optionMaturity = fromTimeNext - fromTime;
        double optionStrike = boundaryLocal;
        double[] boundaryAdjustmentValues = new double[underlying.size()];
        double c = 0.0;
        double d = 0.0;
        if (this.boundaryAdjustmentType == BoundaryAdjustmentType.LINEAR_ANALYTIC) {
            c = AnalyticFormulas.blackScholesOptionValue(boundaryLocal, riskFreeRate, volatility, toTime - fromTimeNext, this.strike);
            d = AnalyticFormulas.blackScholesOptionDelta(boundaryLocal, riskFreeRate, volatility, toTime - fromTimeNext, this.strike);
        } else if (this.boundaryAdjustmentType == BoundaryAdjustmentType.LINEAR_PROPAGATED) {
            c = Math.exp(-riskFreeRate * (fromTimeNext - fromTime)) * boundaryLocal;
            d = Math.exp(-riskFreeRate * (toTime - fromTimeNext));
        } else if (this.boundaryAdjustmentType == BoundaryAdjustmentType.LINEAR_REGRESSED) {
            RandomVariableFromDoubleArray weight = new RandomVariableFromDoubleArray(1.0);
            MonteCarloConditionalExpectationRegression condExpEstimator = new MonteCarloConditionalExpectationRegression(this.getRegressionBasisFunctions(toTime, model, weight));
            double[] paremetersRegressed = condExpEstimator.getLinearRegressionParameters(continuationValues.mult(weight));
            c = paremetersRegressed[0] + boundaryLocal * paremetersRegressed[1];
            d = paremetersRegressed[1];
        } else if (this.boundaryAdjustmentType == BoundaryAdjustmentType.SIMPLE_SUPERHEDGE) {
            c = boundaryLocal;
            d = 1.0;
        } else if (this.boundaryAdjustmentType == BoundaryAdjustmentType.SIMPLE_SUBHEDGE) {
            c = boundaryLocal - this.strike;
            d = 1.0;
        }
        for (int i = 0; i < underlying.size(); ++i) {
            double initialStockValue = underlying.get(i);
            double a = AnalyticFormulas.blackScholesOptionValue(initialStockValue, riskFreeRate, volatility, optionMaturity, optionStrike);
            double b = AnalyticFormulas.blackScholesDigitalOptionValue(initialStockValue, riskFreeRate, volatility, optionMaturity, optionStrike);
            boundaryAdjustmentValues[i] = c * b + d * a;
        }
        RandomVariableFromDoubleArray boundaryAdjustment = boundaryAdjustmentValues.length == 1 ? new RandomVariableFromDoubleArray(0.0, boundaryAdjustmentValues[0]) : new RandomVariableFromDoubleArray(0.0, boundaryAdjustmentValues);
        values.add(boundaryAdjustment);
        return values;
    }

    private RandomVariable[] getRegressionBasisFunctions(double exerciseDate, AssetModelMonteCarloSimulationModel model, RandomVariable weight) throws CalculationException {
        ArrayList<RandomVariable> basisFunctions = new ArrayList<RandomVariable>();
        RandomVariable basisFunction = new RandomVariableFromDoubleArray(exerciseDate, 1.0);
        basisFunctions.add(basisFunction.mult(weight));
        basisFunction = model.getAssetValue(exerciseDate, 0);
        basisFunctions.add(basisFunction.mult(weight));
        return basisFunctions.toArray(new RandomVariable[0]);
    }

    public class ConstantBarrier
    implements Barrier {
        private final AssetModelMonteCarloSimulationModel scheme;

        public ConstantBarrier(AssetModelMonteCarloSimulationModel scheme) {
            this.scheme = scheme;
        }

        @Override
        public RandomVariableFromDoubleArray[] getBarrierDirection(int timeIndex, RandomVariable[] realizationPredictor) {
            if (timeIndex >= this.scheme.getTimeDiscretization().getNumberOfTimeSteps() + 1) {
                return null;
            }
            RandomVariableFromDoubleArray[] barrierDirection = new RandomVariableFromDoubleArray[]{new RandomVariableFromDoubleArray(0.0, 1.0)};
            return barrierDirection;
        }

        @Override
        public RandomVariableFromDoubleArray getBarrierLevel(int timeIndex, RandomVariable[] realizationPredictor) throws CalculationException {
            if (timeIndex >= this.scheme.getTimeDiscretization().getNumberOfTimeSteps() + 1) {
                return null;
            }
            double simulationTime = this.scheme.getTime(timeIndex);
            double riskFreeRate = ((MonteCarloBlackScholesModel)this.scheme).getModel().getRiskFreeRate().doubleValue();
            double volatility = ((MonteCarloBlackScholesModel)this.scheme).getModel().getVolatility().doubleValue();
            double boundaryLocal = 1.0 * Math.exp(riskFreeRate * EuropeanOptionWithBoundary.this.maturity + 1.0 * Math.sqrt(EuropeanOptionWithBoundary.this.maturity));
            boundaryLocal = 1.0 * Math.exp(riskFreeRate * simulationTime + 1.0 * Math.sqrt(simulationTime));
            RandomVariableFromDoubleArray barrierLevel = new RandomVariableFromDoubleArray(simulationTime, Math.log(boundaryLocal));
            RandomVariable underlying = this.scheme.getAssetValue(timeIndex - 1, 0);
            barrierLevel.sub(underlying.log());
            barrierLevel.sub((riskFreeRate - 0.5 * volatility * volatility) * this.scheme.getTimeDiscretization().getTimeStep(timeIndex - 1));
            return barrierLevel;
        }

        @Override
        public boolean isUpperBarrier() {
            return true;
        }
    }

    static enum BoundaryAdjustmentType {
        LINEAR_ANALYTIC,
        LINEAR_PROPAGATED,
        SIMPLE_SUPERHEDGE,
        SIMPLE_SUBHEDGE,
        LINEAR_REGRESSED;

    }
}

