/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.Arrays;
import java.util.HashMap;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;

public class FiniteDifferenceDeltaHedgedPortfolio
extends AbstractAssetMonteCarloProduct {
    private final AbstractAssetMonteCarloProduct productToHedge;
    private final AssetModelMonteCarloSimulationModel modelUsedForHedging;

    public FiniteDifferenceDeltaHedgedPortfolio(AbstractAssetMonteCarloProduct productToHedge, AssetModelMonteCarloSimulationModel modelUsedForHedging) {
        this.productToHedge = productToHedge;
        this.modelUsedForHedging = modelUsedForHedging;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AssetModelMonteCarloSimulationModel model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        int numberOfPath = model.getNumberOfPaths();
        double[] amountOfUderlyingAsset = new double[numberOfPath];
        double[] amountOfNumeraireAsset = new double[numberOfPath];
        RandomVariable underlyingToday = model.getAssetValue(0.0, 0);
        RandomVariable numeraireToday = model.getNumeraire(0.0);
        double initialValueAsset = underlyingToday.get(0);
        double initialValueNumeraire = numeraireToday.get(0);
        double valueOfOptionAccordingHedgeModel = this.productToHedge.getValue(this.modelUsedForHedging);
        Arrays.fill(amountOfNumeraireAsset, valueOfOptionAccordingHedgeModel / initialValueNumeraire);
        Arrays.fill(amountOfUderlyingAsset, 0.0);
        for (int timeIndex = 0; timeIndex < timeIndexEvaluationTime; ++timeIndex) {
            double time = model.getTime(timeIndex);
            RandomVariable underlyingAtTimeIndex = model.getAssetValue(timeIndex, 0);
            RandomVariable numeraireAtTimeIndex = model.getNumeraire(timeIndex);
            for (int path = 0; path < model.getNumberOfPaths(); ++path) {
                double newNumberOfNumeraireAsset;
                double delta;
                double underlyingValue = underlyingAtTimeIndex.get(path);
                double numeraireValue = numeraireAtTimeIndex.get(path);
                double shift = initialValueAsset * 1.0E-8;
                HashMap<String, Double> dataUpShift = new HashMap<String, Double>();
                dataUpShift.put("initialValue", new Double(underlyingValue + shift));
                dataUpShift.put("initialTime", new Double(time));
                HashMap<String, Double> dataDownShift = new HashMap<String, Double>();
                dataDownShift.put("initialValue", new Double(underlyingValue - shift));
                dataDownShift.put("initialTime", new Double(time));
                double newNumberOfStocks = delta = (this.productToHedge.getValue(time, (AssetModelMonteCarloSimulationModel)this.modelUsedForHedging.getCloneWithModifiedData(dataUpShift)).getAverage() - this.productToHedge.getValue(time, (AssetModelMonteCarloSimulationModel)this.modelUsedForHedging.getCloneWithModifiedData(dataDownShift)).getAverage()) / (2.0 * shift);
                double stocksToBuy = newNumberOfStocks - amountOfUderlyingAsset[path];
                double numeraireAssetsToBuy = -(stocksToBuy * underlyingValue) / numeraireValue;
                amountOfNumeraireAsset[path] = newNumberOfNumeraireAsset = amountOfNumeraireAsset[path] + numeraireAssetsToBuy;
                amountOfUderlyingAsset[path] = newNumberOfStocks;
            }
        }
        double[] portfolioValue = new double[numberOfPath];
        RandomVariable underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariable numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        for (int path = 0; path < underlyingAtEvaluationTime.size(); ++path) {
            double underlyingValue = underlyingAtEvaluationTime.get(path);
            portfolioValue[path] = amountOfNumeraireAsset[path] * numeraireAtEvaluationTime.get(path) + amountOfUderlyingAsset[path] * underlyingValue;
        }
        return new RandomVariableFromDoubleArray(evaluationTime, portfolioValue);
    }
}

