/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.automaticdifferentiation.backward.alternative;

import java.util.ArrayList;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.automaticdifferentiation.backward.alternative.RandomVariableUniqueVariable;
import net.finmath.stochastic.RandomVariable;

public class RandomVariableUniqueVariableFactory
extends AbstractRandomVariableFactory {
    private static final long serialVersionUID = -45129698827709536L;
    private static ArrayList<RandomVariable> listOfAllVariables = new ArrayList();
    private static int currentFactoryID = 0;

    public RandomVariable createRandomVariable(RandomVariable randomvariable, boolean isConstant, ArrayList<RandomVariableUniqueVariable> parentVariables, RandomVariableUniqueVariable.OperatorType parentOperatorType) {
        int factoryID = currentFactoryID++;
        listOfAllVariables.add(factoryID, randomvariable);
        return new RandomVariableUniqueVariable(factoryID, isConstant, parentVariables, parentOperatorType);
    }

    public RandomVariable createRandomVariable(double time, double value, boolean isConstant) {
        RandomVariableFromArrayFactory randomvariablefactory = new RandomVariableFromArrayFactory();
        RandomVariable newrandomvariable = randomvariablefactory.createRandomVariable(time, value);
        return this.createRandomVariable(newrandomvariable, isConstant, null, null);
    }

    public RandomVariable createRandomVariable(double time, double[] values, boolean isConstant) {
        RandomVariableFromArrayFactory randomvariablefactory = new RandomVariableFromArrayFactory();
        RandomVariable newrandomvariable = randomvariablefactory.createRandomVariable(time, values);
        return this.createRandomVariable(newrandomvariable, isConstant, null, null);
    }

    public RandomVariable createRandomVariable(RandomVariable randomvariable) {
        return this.createRandomVariable(randomvariable, false, null, null);
    }

    @Override
    public RandomVariable createRandomVariable(double time, double value) {
        return this.createRandomVariable(time, value, false);
    }

    @Override
    public RandomVariable createRandomVariable(double time, double[] values) {
        return this.createRandomVariable(time, values, false);
    }

    public ArrayList<RandomVariable> getListOfAllVariables() {
        return listOfAllVariables;
    }

    public int getNumberOfEntriesInList() {
        return currentFactoryID;
    }
}

