/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.conditionalexpectation;

import java.util.List;
import java.util.function.Function;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.AbstractMonteCarloProduct;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.conditionalexpectation.RegressionBasisFunctionsProvider;
import net.finmath.stochastic.RandomVariable;

public class RegressionBasisFunctionsFromProducts
implements RegressionBasisFunctionsProvider {
    private final List<AbstractMonteCarloProduct> products;

    public RegressionBasisFunctionsFromProducts(List<AbstractMonteCarloProduct> products) {
        this.products = products;
    }

    @Override
    public RandomVariable[] getBasisFunctions(final double evaluationTime, final MonteCarloSimulationModel model) {
        Function<AbstractMonteCarloProduct, RandomVariable> valuation = new Function<AbstractMonteCarloProduct, RandomVariable>(){

            @Override
            public RandomVariable apply(AbstractMonteCarloProduct p) {
                RandomVariable value = null;
                try {
                    value = p.getValue(evaluationTime, model);
                }
                catch (CalculationException e) {
                    throw new IllegalArgumentException("Product " + p + " cannot be valued by model " + model + " at time " + evaluationTime, e);
                }
                if (value.getFiltrationTime() > evaluationTime) {
                    throw new IllegalArgumentException("Product " + p + " valued by model " + model + " cannot be used as basis function at time " + evaluationTime + ". Filtration time is " + value.getFiltrationTime());
                }
                return value;
            }
        };
        return (RandomVariable[])this.products.stream().map(valuation).toArray(RandomVariable[]::new);
    }
}

