/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.hybridassetinterestrate;

import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.MonteCarloSimulationModel;
import net.finmath.montecarlo.hybridassetinterestrate.HybridAssetMonteCarloSimulation;
import net.finmath.montecarlo.hybridassetinterestrate.RiskFactorFX;
import net.finmath.montecarlo.hybridassetinterestrate.RiskFactorForwardRate;
import net.finmath.montecarlo.hybridassetinterestrate.RiskFactorID;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.process.MonteCarloProcessFromProcessModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class CrossCurrencyLIBORMarketModelFromModels
implements HybridAssetMonteCarloSimulation {
    private final String baseModel;
    private final Map<String, LIBORModelMonteCarloSimulationModel> interestRatesModels;
    private final Map<String, MonteCarloProcessFromProcessModel> fxModels;

    public CrossCurrencyLIBORMarketModelFromModels(String baseModel, Map<String, LIBORModelMonteCarloSimulationModel> interestRatesModels, Map<String, MonteCarloProcessFromProcessModel> fxModels) {
        this.baseModel = baseModel;
        this.interestRatesModels = interestRatesModels;
        this.fxModels = fxModels;
    }

    public LIBORModelMonteCarloSimulationModel getBaseModel() {
        return this.interestRatesModels.get(this.baseModel);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.getBaseModel().getRandomVariableForConstant(value);
    }

    @Override
    public int getNumberOfPaths() {
        return this.getBaseModel().getNumberOfPaths();
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.getBaseModel().getTimeDiscretization();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.getBaseModel().getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.getBaseModel().getTimeIndex(time);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.getBaseModel().getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) throws CalculationException {
        return this.getBaseModel().getMonteCarloWeights(time);
    }

    @Override
    public MonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public RandomVariable getNumeraire(double time) throws CalculationException {
        return this.getBaseModel().getNumeraire(time);
    }

    @Override
    public RandomVariable getNumeraire(String account, double time) throws CalculationException {
        return this.interestRatesModels.get(account).getNumeraire(time);
    }

    @Override
    public RandomVariable getValue(RiskFactorID riskFactorIdentifyer, double time) throws CalculationException {
        if (riskFactorIdentifyer instanceof RiskFactorForwardRate) {
            RiskFactorForwardRate riskFactorForwardRate = (RiskFactorForwardRate)riskFactorIdentifyer;
            LIBORModelMonteCarloSimulationModel riskFactorModel = this.interestRatesModels.get(riskFactorIdentifyer.getName());
            RandomVariable forwardRate = riskFactorModel.getLIBOR(time, riskFactorForwardRate.getPeriodStart(), riskFactorForwardRate.getPeriodEnd());
            if (!riskFactorIdentifyer.getName().equals(this.baseModel)) {
                MonteCarloProcessFromProcessModel riskFactorModelFX = this.fxModels.get(riskFactorIdentifyer.getName());
                RandomVariable randomVariable = riskFactorModelFX.getProcessValue(riskFactorModelFX.getTimeIndex(time), 0);
            }
            return forwardRate;
        }
        if (riskFactorIdentifyer instanceof RiskFactorFX) {
            if (riskFactorIdentifyer.getName().equals(this.baseModel)) {
                return new Scalar(1.0);
            }
            MonteCarloProcessFromProcessModel riskFactorModelFX = this.fxModels.get(riskFactorIdentifyer.getName());
            RandomVariable fxRate = riskFactorModelFX.getProcessValue(riskFactorModelFX.getTimeIndex(time), 0);
            LIBORModelMonteCarloSimulationModel riskFactorModel = this.interestRatesModels.get(riskFactorIdentifyer.getName());
            fxRate = fxRate.mult(this.getNumeraire(time)).div(riskFactorModel.getNumeraire(time));
            return fxRate;
        }
        throw new IllegalArgumentException("Risk factor unsupported: " + riskFactorIdentifyer);
    }

    LIBORModelMonteCarloSimulationModel getInterestRateModel(String model) {
        return this.interestRatesModels.get(model);
    }
}

